/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.step;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.step.Step;
import whatap.util.BitUtil;

public class SqlStepX
extends Step {
    public byte xtype;
    public int hash;
    public int elapsed;
    public long error;
    public int dbc;
    public byte[] p1;
    public byte[] p2;
    public byte pcrc;
    public int start_cpu;
    public long start_mem;
    public int[] stack;
    public int sid;
    public int serial;
    public int inst;

    public byte getStepType() {
        return 18;
    }

    public int getElapsed() {
        return this.elapsed;
    }

    public void write(DataOutputX out) throws IOException {
        super.write(out);
        out.writeByte(this.sid == 0 ? 0 : 1);
        out.writeDecimal(this.hash);
        out.writeDecimal(this.elapsed);
        out.writeDecimal(this.error);
        out.writeByte(this.xtype);
        out.writeDecimal(this.dbc);
        out.writeBlob(this.p1);
        out.writeBlob(this.p2);
        out.writeByte(this.pcrc);
        out.writeDecimal(this.start_cpu);
        out.writeDecimal(this.start_mem);
        out.writeArray(this.stack);
        if (this.sid != 0) {
            out.writeDecimal(this.sid);
            long v = BitUtil.composite(this.inst, this.serial);
            out.writeDecimal(v);
        }
    }

    public Step read(DataInputX in) throws IOException {
        super.read(in);
        byte ver = in.readByte();
        this.hash = (int)in.readDecimal();
        this.elapsed = (int)in.readDecimal();
        this.error = in.readDecimal();
        this.xtype = in.readByte();
        this.dbc = (int)in.readDecimal();
        this.p1 = in.readBlob();
        this.p2 = in.readBlob();
        this.pcrc = in.readByte();
        this.start_cpu = (int)in.readDecimal();
        this.start_mem = (int)in.readDecimal();
        this.stack = in.readArray(this.stack);
        if (ver == 0) {
            return this;
        }
        this.sid = (int)in.readDecimal();
        long inst_and_serial = in.readDecimal();
        this.inst = BitUtil.getHigh(inst_and_serial);
        this.serial = BitUtil.getLow(inst_and_serial);
        return this;
    }
}

