/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.sm;

import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.pack.sm.Cpu;
import whatap.lang.pack.sm.CpuLinux;
import whatap.lang.pack.sm.CpuWindow;
import whatap.lang.pack.sm.Memory;
import whatap.lang.pack.sm.MemoryLinux;
import whatap.lang.pack.sm.MemoryWindow;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;

public class SMBasePack
extends AbstractPack {
    public short type;
    public short os;
    public int ip;
    public Cpu cpu;
    public Cpu[] cores;
    public Memory memory;
    public long uptime;
    public long epochtime;
    public MapValue extra;

    public SMBasePack(short p) {
        this.type = p;
    }

    public SMBasePack() {
        this.type = (short)12296;
    }

    public short getPackType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("OSBasePack ");
        sb.append(super.toString());
        return sb.toString();
    }

    public void write(DataOutputX dout) {
        switch (this.type) {
            case 12288: {
                this.writev1(dout);
                break;
            }
            case 12296: {
                this.writev2(dout);
                break;
            }
            default: {
                System.out.println("SMBasePack Pack type not supported " + this.type);
            }
        }
    }

    public void writev1(DataOutputX dout) {
        super.write(dout);
        dout.writeInt(this.ip);
        dout.writeShort(this.os);
        this.cpu.write(dout);
        dout.writeByte(this.cores.length);
        for (int i = 0; i < this.cores.length; ++i) {
            this.cores[i].write(dout);
        }
        this.memory.write(dout);
        dout.writeDecimal(this.uptime);
        dout.writeLong(this.epochtime);
    }

    public void writev2(DataOutputX doutx) {
        DataOutputX dout = new DataOutputX();
        super.write(dout);
        dout.writeInt(this.ip);
        dout.writeShort(this.os);
        this.cpu.writev2(dout);
        dout.writeByte(this.cores.length);
        for (int i = 0; i < this.cores.length; ++i) {
            this.cores[i].writev2(dout);
        }
        this.memory.writev2(dout);
        dout.writeDecimal(this.uptime);
        dout.writeLong(this.epochtime);
        if (this.extra != null && this.extra.size() > 0) {
            dout.writeByte(1);
            dout.writeValue(this.extra);
        } else {
            dout.writeByte(0);
        }
        doutx.writeBlob(dout.toByteArray());
    }

    public Pack read(DataInputX din) {
        switch (this.type) {
            case 12288: {
                this.readv1(din);
                break;
            }
            case 12296: {
                this.readv2(din);
                break;
            }
            default: {
                System.out.println("SMBasePack Pack type not supported " + this.type);
            }
        }
        return this;
    }

    public Pack readv1(DataInputX din) {
        super.read(din);
        this.ip = din.readInt();
        this.os = din.readShort();
        switch (this.os) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.cpu = new CpuLinux();
                this.memory = new MemoryLinux();
                break;
            }
            case 2: {
                this.cpu = new CpuWindow();
                this.memory = new MemoryWindow();
                break;
            }
            default: {
                return this;
            }
        }
        this.cpu.read(din);
        int cnt = din.readByte();
        this.cores = new Cpu[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.cores[i] = this.cpu.create();
            this.cores[i].read(din);
        }
        this.memory.read(din);
        this.uptime = din.readDecimal();
        this.epochtime = din.readLong();
        return this;
    }

    public Pack readv2(DataInputX dinx) {
        Value v;
        DataInputX din = new DataInputX(dinx.readBlob());
        super.read(din);
        this.ip = din.readInt();
        this.os = din.readShort();
        switch (this.os) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.cpu = new CpuLinux();
                this.memory = new MemoryLinux();
                break;
            }
            case 2: {
                this.cpu = new CpuWindow();
                this.memory = new MemoryWindow();
                break;
            }
            default: {
                return this;
            }
        }
        this.cpu.readv2(din);
        int cnt = din.readByte();
        this.cores = new Cpu[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.cores[i] = this.cpu.create();
            this.cores[i].readv2(din);
        }
        this.memory.readv2(din);
        this.uptime = din.readDecimal();
        this.epochtime = din.readLong();
        if (din.available() == 0) {
            return this;
        }
        if (din.readByte() > 0 && (v = din.readValue()) instanceof MapValue) {
            this.extra = (MapValue)v;
        }
        return this;
    }
}

