/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import whatap.io.DataIOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.value.IntMapValue;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDbTablePack
extends AbstractPack {
    protected StringKeyLinkedMap<List<IntMapValue>> dbms = new StringKeyLinkedMap<List<IntMapValue>>(){

        @Override
        protected List<IntMapValue> create(String db) {
            return new ArrayList<IntMapValue>();
        }
    };

    public String[] getDBNames() {
        return this.dbms.keyArray();
    }

    public int size() {
        return this.dbms.size();
    }

    public int size(String dbname) {
        List<IntMapValue> m = this.dbms.get(dbname);
        return m == null ? 0 : m.size();
    }

    public void add(String db, IntMapValue row) {
        this.dbms.intern(db).add(row);
    }

    public void add(String db, List<IntMapValue> rows) {
        this.dbms.put(db, rows);
    }

    public IntMapValue get(String db, int inx) {
        List<IntMapValue> dbm = this.dbms.get(db);
        return dbm != null ? dbm.get(inx) : null;
    }

    public List<IntMapValue> get(String db) {
        return this.dbms.get(db);
    }

    @Override
    public abstract short getPackType();

    @Override
    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeShort(this.dbms.size());
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<List<IntMapValue>>> en = this.dbms.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<List<IntMapValue>> ent = en.nextElement();
            dout.writeText(ent.getKey());
            dout.writeShort(ent.getValue().size());
            for (IntMapValue r : ent.getValue()) {
                try {
                    r.write(dout);
                }
                catch (IOException e) {
                    throw new DataIOException(e);
                }
            }
        }
    }

    @Override
    public Pack read(DataInputX din) {
        super.read(din);
        int sz = din.readShort();
        for (int i = 0; i < sz; ++i) {
            String db = din.readText();
            int listSz = din.readShort();
            ArrayList<IntMapValue> list = new ArrayList<IntMapValue>();
            for (int j = 0; j < listSz; ++j) {
                try {
                    list.add((IntMapValue)new IntMapValue().read(din));
                    continue;
                }
                catch (IOException e) {
                    throw new DataIOException(e);
                }
            }
            this.dbms.put(db, list);
        }
        return this;
    }
}

