/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.util.ArrayList;
import java.util.List;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.util.ArrayUtil;
import whatap.util.StringUtil;

public class TextPack
extends AbstractPack {
    public List<TextRec> records = new ArrayList<TextRec>();

    public short getPackType() {
        return 1792;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TEXT");
        sb.append(super.toString());
        sb.append(",records=" + this.records.size());
        return sb.toString();
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        dout.writeDecimal(this.records.size());
        for (int i = 0; i < this.records.size(); ++i) {
            TextRec r = this.records.get(i);
            dout.writeByte(r.type);
            dout.writeInt(r.hash);
            if (r.type != 19) {
                dout.writeText(((Text)r.text).str);
                continue;
            }
            SqlParam sql = (SqlParam)r.text;
            dout.writeInt(sql.cipher);
            dout.writeBlob(sql.p1);
            dout.writeBlob(sql.p2);
        }
    }

    public Pack read(DataInputX din) {
        super.read(din);
        int size = (int)din.readDecimal();
        for (int i = 0; i < size; ++i) {
            TextRec r = new TextRec();
            r.type = din.readByte();
            r.hash = din.readInt();
            if (r.type != 19) {
                r.text = new Text(din.readText());
            } else {
                SqlParam sql = new SqlParam();
                sql.cipher = din.readInt();
                sql.p1 = din.readBlob();
                sql.p2 = din.readBlob();
                r.text = sql;
            }
            this.records.add(r);
        }
        return this;
    }

    public static class TextRec {
        public byte type;
        public int hash;
        public IText text;

        public TextRec() {
        }

        public TextRec(byte type, int hash, String text) {
            this.type = type;
            this.hash = hash;
            this.text = new Text(text);
        }

        public TextRec(byte type, int hash, SqlParam p) {
            this.type = type;
            this.hash = hash;
            this.text = p;
        }

        public String toString() {
            return "[type=" + this.type + ", hash=" + this.hash + ", text=" + this.text + "]";
        }
    }

    public static class SqlParam
    implements IText {
        public int cipher;
        public byte[] p1;
        public byte[] p2;

        public SqlParam() {
        }

        public SqlParam(int cipher, byte[] p1, byte[] p2) {
            this.cipher = cipher;
            this.p1 = p1;
            this.p2 = p2;
        }

        public String toString() {
            return "****";
        }

        public String toString(int length) {
            return "****";
        }

        public int length() {
            return 4 + ArrayUtil.len(this.p1) + ArrayUtil.len(this.p2);
        }
    }

    public static class Text
    implements IText {
        public String str;

        public Text(String str) {
            this.str = str;
        }

        public int length() {
            return this.str == null ? 0 : this.str.length();
        }

        public String toString() {
            return this.str;
        }

        public String toString(int length) {
            return StringUtil.truncate(this.str, length);
        }
    }

    public static interface IText {
        public int length();

        public String toString(int var1);
    }
}

