/*
 * Decompiled with CFR 0.152.
 */
package whatap.lang.pack;

import java.io.IOException;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.Pack;
import whatap.lang.service.TxRecord;
import whatap.lang.step.Step;
import whatap.util.ArrayUtil;
import whatap.util.DateUtil;

public class ProfilePack
extends AbstractPack {
    public TxRecord transaction;
    public byte[] steps;

    public short getPackType() {
        return 768;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Profile ");
        sb.append(super.toString());
        if (this.transaction != null) {
            sb.append(" time=" + DateUtil.timestamp(this.transaction.endTime));
            sb.append(" active=" + this.transaction.active);
        }
        sb.append(" step_bytes=" + ArrayUtil.len(this.steps));
        return sb.toString();
    }

    public void write(DataOutputX dout) {
        super.write(dout);
        this.transaction.write(dout);
        dout.writeBlob(this.steps);
    }

    public Pack read(DataInputX din) {
        super.read(din);
        this.transaction = new TxRecord().read(din);
        this.steps = din.readBlob();
        return this;
    }

    public ProfilePack setProfile(Step[] steps) throws IOException {
        this.steps = Step.toBytes(steps);
        return this;
    }
}

