/*
 * Decompiled with CFR 0.152.
 */
package whatap.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.util.FileUtil;
import whatap.util.IClose;
import whatap.util.LongKeyLinkedMap;

public class BufferedRandomAccessX
implements IClose {
    private final RandomAccessFile file;
    private final LongKeyLinkedMap<byte[]> buffer;
    private final int blockSize;
    private long fileLength = 0L;
    public long readAccessCount;
    private FileChannel channel;
    private long offset = 0L;

    public BufferedRandomAccessX(RandomAccessFile file) throws IOException {
        this(file, 8192, 1, false);
    }

    public BufferedRandomAccessX(RandomAccessFile file, boolean useNio) throws IOException {
        this(file, 8192, 1, useNio);
    }

    public BufferedRandomAccessX(RandomAccessFile file, int blockSize, int numberOfBlock) throws IOException {
        this(file, blockSize, numberOfBlock, false);
    }

    public BufferedRandomAccessX(RandomAccessFile file, int blockSize, int numberOfBlock, boolean useNio) throws IOException {
        this.file = file;
        this.buffer = new LongKeyLinkedMap().setMax(numberOfBlock);
        this.blockSize = blockSize;
        this.fileLength = file.length();
        if (useNio) {
            this.channel = this.file.getChannel();
        }
    }

    public synchronized byte[] read(long pos, int length) throws IOException {
        if (pos >= this.fileLength) {
            return null;
        }
        this.offset = pos + (long)length;
        DataOutputX out = new DataOutputX();
        int posOnBlock = (int)(pos % (long)this.blockSize);
        if (posOnBlock > 0) {
            byte[] blockBytes = this.getReadBlock(pos / (long)this.blockSize);
            if (blockBytes == null) {
                return null;
            }
            if (blockBytes.length < this.blockSize) {
                int readLen = Math.min(blockBytes.length - posOnBlock, length);
                return DataInputX.get(blockBytes, posOnBlock, readLen);
            }
            int readLen = Math.min(this.blockSize - posOnBlock, length);
            out.write(DataInputX.get(blockBytes, posOnBlock, readLen));
            length -= readLen;
            pos += (long)readLen;
        }
        int blockCount = length / this.blockSize;
        for (int i = 0; i < blockCount; ++i) {
            byte[] blockBytes = this.getReadBlock(pos / (long)this.blockSize);
            if (blockBytes == null) {
                return out.toByteArray();
            }
            out.write(blockBytes);
            pos += (long)this.blockSize;
            length -= this.blockSize;
        }
        if (length == 0) {
            return out.toByteArray();
        }
        int remainder = length;
        byte[] block = this.getReadBlock(pos / (long)this.blockSize);
        if (block != null) {
            remainder = Math.min(block.length, remainder);
            out.write(DataInputX.get(block, 0, remainder));
        }
        return out.toByteArray();
    }

    public long getLength() throws IOException {
        if (this.channel == null) {
            return this.file.length();
        }
        return this.channel.size();
    }

    public void append(byte[] data) throws IOException {
        this.write(this.fileLength, data);
    }

    public synchronized void write(long pos, byte[] data) throws IOException {
        byte[] blockBytes;
        if (data == null || data.length == 0) {
            return;
        }
        if (pos >= this.fileLength) {
            this.offset = this.fileLength + (long)data.length;
            this.seek(this.fileLength);
            this.writeReal(data);
            return;
        }
        this.offset = pos + (long)data.length;
        this.seek(pos);
        this.writeReal(data);
        int length = data.length;
        int offset = 0;
        int posOnBlock = (int)(pos % (long)this.blockSize);
        if (posOnBlock > 0) {
            long blockNumber = pos / (long)this.blockSize;
            byte[] blockBytes2 = this.buffer.get(blockNumber);
            int writeLen = Math.min(this.blockSize - posOnBlock, length);
            if (blockBytes2 != null) {
                if (this.blockSize == blockBytes2.length) {
                    System.arraycopy(data, offset, blockBytes2, posOnBlock, writeLen);
                } else {
                    this.buffer.remove(blockNumber);
                }
            }
            length -= writeLen;
            pos += (long)writeLen;
            offset += writeLen;
        }
        if (length == 0) {
            return;
        }
        int blockCount = length / this.blockSize;
        for (int i = 0; i < blockCount; ++i) {
            long blockNumber = pos / (long)this.blockSize;
            blockBytes = this.buffer.get(blockNumber);
            if (blockBytes != null) {
                if (this.blockSize == blockBytes.length) {
                    System.arraycopy(data, offset, blockBytes, 0, this.blockSize);
                } else {
                    this.buffer.remove(blockNumber);
                }
            }
            length -= this.blockSize;
            pos += (long)this.blockSize;
            offset += this.blockSize;
        }
        int remainder = length;
        if (remainder == 0) {
            return;
        }
        if (remainder < 0) {
            throw new IOException("Write fail remainder=" + remainder + " pos=" + pos);
        }
        long blockNumber = pos / (long)this.blockSize;
        blockBytes = this.buffer.get(blockNumber);
        if (blockBytes == null) {
            return;
        }
        if (this.blockSize == blockBytes.length) {
            System.arraycopy(data, offset, blockBytes, 0, remainder);
        } else {
            this.buffer.remove(blockNumber);
        }
    }

    private void writeReal(byte[] data) throws IOException {
        if (this.channel == null) {
            this.file.write(data);
        } else {
            ByteBuffer dst = ByteBuffer.wrap(data);
            this.channel.write(dst);
        }
        this.fileLength = this.getLength();
    }

    private byte[] getReadBlock(long blockNumber) throws IOException {
        byte[] blockBytes = this.buffer.get(blockNumber);
        if (blockBytes != null && blockBytes.length == this.blockSize) {
            return blockBytes;
        }
        long pos = blockNumber * (long)this.blockSize;
        if (pos >= this.fileLength) {
            return null;
        }
        ++this.readAccessCount;
        this.seek(pos);
        long len = Math.min(this.fileLength - pos, (long)this.blockSize);
        blockBytes = new byte[(int)len];
        this.readReal(blockBytes);
        this.buffer.put(blockNumber, blockBytes);
        return blockBytes;
    }

    private void seek(long pos) throws IOException {
        if (this.channel == null) {
            this.file.seek(pos);
        } else {
            this.channel.position(pos);
        }
    }

    private void readReal(byte[] block) throws IOException {
        if (this.channel == null) {
            this.file.readFully(block);
        } else {
            ByteBuffer dst = ByteBuffer.wrap(block);
            this.channel.read(dst);
        }
    }

    public void close() {
        if (this.channel != null) {
            FileUtil.close(this.channel);
        }
        FileUtil.close(this.file);
    }

    public int readInt(long pos) throws IOException {
        byte[] buf = this.read(pos, 4);
        return DataInputX.toInt(buf, 0);
    }

    public void writeInt(long pos, int i) throws IOException {
        this.write(pos, DataOutputX.toBytes(i));
    }

    public byte readByte(long pos) throws IOException {
        byte[] buf = this.read(pos, 1);
        return buf[0];
    }

    public long getOffset() {
        return this.offset;
    }

    public short readShort(long pos) throws IOException {
        byte[] buf = this.read(pos, 2);
        return DataInputX.toShort(buf, 0);
    }
}

