/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.util;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import whatap.util.HashUtil;
import whatap.util.Hexa32;
import whatap.util.ParamText;
import whatap.util.StringUtil;

public class OidUtil {
    protected static String stime;
    public Map<String, String> oidParam = new TreeMap<String, String>();

    public static int mkOid(String oname) {
        return HashUtil.hash(oname);
    }

    public void setIp(String ip) {
        ip = ip.replace('.', '-');
        String[] ips = StringUtil.split(ip, '-');
        this.oidParam.put("ip", ip);
        for (int x = 0; x < ips.length; ++x) {
            this.oidParam.put("ip" + x, ips[x]);
        }
    }

    public void setHostName(String hostName) {
        this.oidParam.put("hostname", hostName);
    }

    public void setPort(int port) {
        this.oidParam.put("port", Integer.toString(port));
    }

    public void setPid(int pid) {
        this.oidParam.put("pid", Integer.toString(pid));
    }

    public void setType(String type) {
        this.oidParam.put("type", type);
    }

    public void setAttr(String key, String value) {
        this.oidParam.put(key, value);
    }

    public String mkOname(String pattern) {
        if (stime == null) {
            stime = Hexa32.toString32((int)(System.currentTimeMillis() % Integer.MAX_VALUE));
        }
        this.oidParam.put("stime", stime);
        ParamText p = new ParamText(pattern, "{", "}");
        List<String> keyList = p.getKeyList();
        for (String key : keyList) {
            if (this.oidParam.containsKey(key)) continue;
            if (System.getProperty(key) != null) {
                this.oidParam.put(key, System.getProperty(key));
                continue;
            }
            if (System.getenv(key) != null) {
                this.oidParam.put(key, System.getenv(key));
                continue;
            }
            this.oidParam.put(key, key);
        }
        return p.getText(this.oidParam);
    }

    public String toString(int oid) {
        return Integer.toString(oid);
    }

    public void setCmd(String cmd) {
        String[] cmds = StringUtil.isEmpty(cmd) ? new String[]{} : StringUtil.tokenizer(cmd, " ");
        for (int i = 0; i < 10; ++i) {
            if (i < cmds.length) {
                this.oidParam.put("cmd" + i, cmds[i]);
                continue;
            }
            this.oidParam.put("cmd" + i, "");
        }
    }

    public void setSysProperties() {
    }
}

