/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.urlnorm;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDebug;
import whatap.agent.trace.urlnorm.RebuildUrlNormScheduler;
import whatap.agent.trace.urlnorm.ScanPathMap;
import whatap.agent.trace.urlnorm.UrlNormMap;
import whatap.agent.trace.urlnorm.UrlNormProxy;
import whatap.agent.trace.urlnorm.UrlPathTree;
import whatap.lang.conf.ConfObserver;
import whatap.util.AnsiPrint;
import whatap.util.IntLinkedSet;
import whatap.util.StringEnumer;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

public class UrlNormPathTreeBuilder {
    static Configure conf = Configure.getInstance();
    public static int orgUrlNormHash = 0;
    static String normalize_urls = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_normalize_urls);
    static boolean last_auto_normalize_enabled = UrlNormPathTreeBuilder.conf.trace_auto_normalize_enabled;
    static String last_auto_normalize_base_context = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_auto_normalize_base_context);
    public static UrlNormMap urlNormMap = new UrlNormMap();
    public static StringLinkedSet lastPathParamUrlSet = null;
    public static IntLinkedSet lastNoPathParamUrlHashSet = null;
    private static long last_build = 0L;

    public static void start(long stime) {
        if (ConfDebug.debug_urlnorm) {
            Logger.green("UrlNorm UrlNormPathTreeBuilder.start() after=" + (stime - System.currentTimeMillis()) + "ms");
        }
        ConfObserver.add("UrlNormPathTreeBuilder", new Runnable(){

            public void run() {
                String value = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_normalize_urls);
                String now_trace_auto_normalize_base_context = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_auto_normalize_base_context);
                if (!(normalize_urls.equals(value) && last_auto_normalize_enabled == UrlNormPathTreeBuilder.conf.trace_auto_normalize_enabled && last_auto_normalize_base_context.equals(now_trace_auto_normalize_base_context) && UrlNormPathTreeBuilder.isSameUrlNorm())) {
                    UrlNormPathTreeBuilder.build("ConfigUpdate", null);
                }
            }
        });
        UrlNormPathTreeBuilder.build("Start", null);
        RebuildUrlNormScheduler.fullbuildActiveTime = stime;
    }

    public static synchronized void scanClasses(ScanPathMap pathMap) {
        if (JavaAgent.instrumentation == null || pathMap == null) {
            return;
        }
        long stime = System.currentTimeMillis();
        Class[] classes = JavaAgent.instrumentation.getAllLoadedClasses();
        int scan = 0;
        int err = 10;
        int totClasses = classes.length;
        for (int i = 0; i < totClasses; ++i) {
            try {
                String className;
                if (classes[i].getClassLoader() == null || !(className = classes[i].getName()).startsWith("org.springframework.samples") && (className.startsWith("whatap") || className.startsWith("org.springframework"))) continue;
                ++scan;
                pathMap.scan(classes[i]);
                continue;
            }
            catch (Throwable t) {
                if (err <= 0) continue;
                --err;
                Logger.println("UrlNorm", "UrlNormPathTreeBuilder: " + t.getMessage());
            }
        }
        long dur = System.currentTimeMillis() - stime;
        Logger.println("UrlNorm", AnsiPrint.green("Class Scan tot=" + totClasses + " real=" + scan + " classes " + dur + "ms done. ") + AnsiPrint.green("pathParamUrlSet=#" + pathMap.pathParamUrlSet.size() + "  noParamUrlSet=#" + pathMap.noPathParamUrlHashSet.size()));
    }

    public static synchronized void build(String buildBy, ScanPathMap scanPathMap) {
        normalize_urls = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_normalize_urls);
        last_auto_normalize_enabled = UrlNormPathTreeBuilder.conf.trace_auto_normalize_enabled;
        try {
            String[] urls;
            long now = System.currentTimeMillis();
            if (scanPathMap == null && now < last_build + 10000L) {
                return;
            }
            last_build = now;
            normalize_urls = StringUtil.trimEmpty(UrlNormPathTreeBuilder.conf.trace_normalize_urls);
            UrlPathTree pathTreeTmp = new UrlPathTree();
            IntLinkedSet noNeedTmp = new IntLinkedSet(1025, 1.0f).setMax(10000);
            if (UrlNormPathTreeBuilder.conf.trace_auto_normalize_enabled) {
                StringEnumer en;
                if (scanPathMap != null) {
                    en = scanPathMap.pathParamUrlSet.elements();
                    if (UrlNormPathTreeBuilder.conf._is_trace_auto_normalize_base_context) {
                        while (en.hasMoreElements()) {
                            UrlNormPathTreeBuilder.addPath(pathTreeTmp, UrlNormPathTreeBuilder.conf.trace_auto_normalize_base_context + en.nextString());
                        }
                    } else {
                        while (en.hasMoreElements()) {
                            UrlNormPathTreeBuilder.addPath(pathTreeTmp, en.nextString());
                        }
                    }
                    noNeedTmp.putAll(scanPathMap.noPathParamUrlHashSet);
                    lastPathParamUrlSet = scanPathMap.pathParamUrlSet;
                    lastNoPathParamUrlHashSet = scanPathMap.noPathParamUrlHashSet;
                } else {
                    if (lastPathParamUrlSet != null) {
                        en = lastPathParamUrlSet.elements();
                        if (UrlNormPathTreeBuilder.conf._is_trace_auto_normalize_base_context) {
                            while (en.hasMoreElements()) {
                                UrlNormPathTreeBuilder.addPath(pathTreeTmp, UrlNormPathTreeBuilder.conf.trace_auto_normalize_base_context + en.nextString());
                            }
                        } else {
                            while (en.hasMoreElements()) {
                                UrlNormPathTreeBuilder.addPath(pathTreeTmp, en.nextString());
                            }
                        }
                    }
                    if (lastNoPathParamUrlHashSet != null) {
                        noNeedTmp.putAll(lastNoPathParamUrlHashSet);
                    }
                }
            }
            if (UrlNormPathTreeBuilder.conf.trace_auto_normalize_noneedset_clear_enabled && (urlNormMap.size() > 0 || StringUtil.isNotEmpty(UrlNormPathTreeBuilder.conf.trace_normalize_urls))) {
                noNeedTmp.clear();
            }
            if ((urls = StringUtil.tokenizer(UrlNormPathTreeBuilder.conf.trace_normalize_urls, ",")) != null) {
                for (String u : urls) {
                    if (u != null && u.indexOf("{") >= 0) {
                        UrlNormPathTreeBuilder.addPath(pathTreeTmp, u);
                        continue;
                    }
                    noNeedTmp.put(u.hashCode());
                }
            }
            if ((urls = urlNormMap.getUrls()) != null) {
                for (String u : urls) {
                    if (u != null && u.indexOf("{") >= 0) {
                        UrlNormPathTreeBuilder.addPath(pathTreeTmp, u);
                        continue;
                    }
                    noNeedTmp.put(u.hashCode());
                }
            }
            orgUrlNormHash = urlNormMap.getUrlsHash();
            Logger.println("UrlNorm", AnsiPrint.green("Service PathTree done. ") + "BuildBy=" + buildBy + AnsiPrint.green(" PathTree=" + pathTreeTmp.size()));
            if (ConfDebug.debug_urlnorm) {
                int n = 0;
                Enumeration<String> en = pathTreeTmp.values();
                while (en.hasMoreElements()) {
                    String ent = en.nextElement();
                    if (StringUtil.isEmpty(ent)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("    ");
                    sb.append(n++).append(": ").append(ent).append("\n");
                    Logger.write(AnsiPrint.green(sb.toString()));
                }
            }
            UrlNormProxy.urlPathTree = pathTreeTmp.pathTree;
            UrlNormProxy.noNeedSet = noNeedTmp;
            UrlNormProxy.parsedSet.clear();
        }
        catch (Throwable t) {
            Logger.println("UrlNorm", "UrlNormPathTreeBuilder build:" + t);
        }
    }

    private static void addPath(UrlPathTree pathTree, String path) {
        if ((path = StringUtil.trimEmpty(path)).length() < 3) {
            return;
        }
        pathTree.insert(path);
    }

    public static boolean isSameUrlNorm() {
        return urlNormMap.getUrlsHash() == orgUrlNormHash;
    }
}

