/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.urlnorm;

import java.util.Enumeration;
import whatap.lang.value.ListValue;
import whatap.util.IntKeyLinkedMap;
import whatap.util.StringUtil;

public class UrlNormMap {
    private int hashCode = 0;
    private IntKeyLinkedMap<String> map = new IntKeyLinkedMap().setMax(2000);

    public synchronized int getUrlsHash() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getUrls() {
        String[] out;
        IntKeyLinkedMap<String> intKeyLinkedMap = this.map;
        synchronized (intKeyLinkedMap) {
            int size = this.map.size();
            out = new String[size];
            Enumeration<String> en = this.map.values();
            for (int i = 0; en.hasMoreElements() && i < size; ++i) {
                out[i] = en.nextElement();
            }
        }
        return out;
    }

    public synchronized boolean resetUrls(ListValue urlLv) {
        boolean ischanged = false;
        try {
            int newHashCode = 0;
            IntKeyLinkedMap<String> newMap = new IntKeyLinkedMap().setMax(2000);
            for (int i = 0; i < urlLv.size(); ++i) {
                String url = urlLv.getString(i);
                if (StringUtil.isEmpty(url)) continue;
                newHashCode ^= url.hashCode();
                newMap.put(url.hashCode(), url.intern());
                ischanged = true;
            }
            if (!ischanged) {
                ischanged = newHashCode != this.hashCode;
            }
            this.hashCode = newHashCode;
            this.map = newMap;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ischanged;
    }

    public synchronized boolean addUrls(ListValue urlLv) {
        boolean ischanged = false;
        try {
            for (int i = 0; i < urlLv.size(); ++i) {
                String url = urlLv.getString(i);
                if (StringUtil.isEmpty(url) || this.map.containsKey(url.hashCode())) continue;
                this.map.put(url.hashCode(), url.intern());
                this.hashCode ^= url.hashCode();
                ischanged = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ischanged;
    }

    public int size() {
        return this.map.size();
    }
}

