/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.urlnorm;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDebug;
import whatap.util.AnsiPrint;
import whatap.util.ArrayUtil;
import whatap.util.IntLinkedSet;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;

class ScanPathMap {
    private static HashSet<String> targetAnnotation = new HashSet();
    private static HashSet<String> targetMethodAnnotation = new HashSet();
    private StringKeyLinkedMap<String[]> parentMap = new StringKeyLinkedMap().setMax(2000);
    Configure conf = Configure.getInstance();
    public StringLinkedSet pathParamUrlSet = new StringLinkedSet().setMax(1000);
    public IntLinkedSet noPathParamUrlHashSet = new IntLinkedSet(1025, 1.0f).setMax(10000);
    private static String[] empty;

    ScanPathMap() {
    }

    public boolean scan(Class class1) {
        try {
            if (class1.isInterface()) {
                return false;
            }
            if (Throwable.class.isAssignableFrom(class1)) {
                return false;
            }
            Object[] an = class1.getAnnotations();
            if (!ArrayUtil.isEmpty(an)) {
                for (int j = 0; j < an.length; ++j) {
                    if (!targetAnnotation.contains(an[j].annotationType().getName())) continue;
                    return this.processClass(class1, (Annotation[])an);
                }
            }
        }
        catch (Throwable t) {
            Logger.println(AnsiPrint.red("Skip class scan: " + class1.getName()) + " " + t.getMessage());
        }
        return false;
    }

    private boolean processClass(Class class1, Annotation[] anno) {
        Object[] classPath = null;
        for (int j = 0; j < anno.length; ++j) {
            if (!anno[j].annotationType().getName().endsWith(".RequestMapping")) continue;
            Object[] s = this.getRequestMapValue(anno[j]);
            if (ArrayUtil.isEmpty(s)) break;
            classPath = s;
            if (!ConfDebug.debug_normalize_enabled) break;
            Logger.info("ClassScan", "\tclass detected" + class1.getName() + " -> " + Arrays.toString(classPath));
            break;
        }
        if (!ArrayUtil.isEmpty(classPath)) {
            this.parentMap.put(class1.getName(), (String[])classPath);
        } else {
            classPath = this.parentMap.get(class1.getSuperclass().getName());
            if (!ArrayUtil.isEmpty(classPath)) {
                this.parentMap.put(class1.getName(), (String[])classPath);
            } else {
                classPath = empty;
            }
        }
        switch (classPath.length) {
            case 0: {
                return this.processThis(class1, "");
            }
            case 1: {
                return this.processThis(class1, (String)classPath[0]);
            }
        }
        boolean ok = false;
        for (int i = 0; i < classPath.length; ++i) {
            if (!this.processThis(class1, (String)classPath[i])) continue;
            ok = true;
        }
        return ok;
    }

    protected boolean processThis(Class class1, String classPath) {
        boolean isTarget = false;
        boolean isParamedClassPath = classPath.indexOf(123) >= 0;
        Method[] m = class1.getDeclaredMethods();
        block0: for (int i = 0; i < m.length; ++i) {
            Annotation[] methodAnno;
            if (m[i].getName().startsWith("lambda$") || (methodAnno = m[i].getDeclaredAnnotations()) == null || methodAnno.length == 0) continue;
            for (int j = 0; j < methodAnno.length; ++j) {
                if (!targetMethodAnnotation.contains(methodAnno[j].annotationType().getName())) continue;
                String[] methodPath = this.getRequestMapValue(methodAnno[j]);
                for (int mi = 0; mi < methodPath.length; ++mi) {
                    String path = classPath + methodPath[mi];
                    if (isParamedClassPath || methodPath[mi].indexOf(123) >= 0) {
                        this.pathParamUrlSet.put(path);
                        if (ConfDebug.debug_normalize_enabled) {
                            Logger.info("ClassScan", "\tmethod detected " + class1.getName() + " -> " + path);
                        }
                        isTarget = true;
                        continue;
                    }
                    this.noPathParamUrlHashSet.put(path.hashCode());
                }
                continue block0;
            }
        }
        return isTarget;
    }

    private String[] getRequestMapValue(Annotation an) {
        try {
            Method valMethod = an.annotationType().getMethod("value", new Class[0]);
            return (String[])valMethod.invoke((Object)an, new Object[0]);
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    static {
        targetAnnotation.add("org.springframework.stereotype.Controller");
        targetAnnotation.add("org.springframework.web.bind.annotation.RestController");
        targetMethodAnnotation.add("org.springframework.web.bind.annotation.RequestMapping");
        targetMethodAnnotation.add("org.springframework.web.bind.annotation.GetMapping");
        targetMethodAnnotation.add("org.springframework.web.bind.annotation.PutMapping");
        targetMethodAnnotation.add("org.springframework.web.bind.annotation.PostMapping");
        targetMethodAnnotation.add("org.springframework.web.bind.annotation.DeleteMapping");
        empty = new String[0];
    }
}

