/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace.httpc.urlnorm;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDebug;
import whatap.agent.trace.httpc.urlnorm.HttpcURLNormProxy;
import whatap.agent.trace.httpc.urlnorm.HttpcURLPrefix;
import whatap.agent.trace.httpc.urlnorm.HttpcUrlNorm;
import whatap.agent.trace.urlnorm.UrlNormMap;
import whatap.agent.trace.urlnorm.UrlPathTree;
import whatap.lang.conf.ConfObserver;
import whatap.util.AnsiPrint;
import whatap.util.ArrayUtil;
import whatap.util.CompareUtil;
import whatap.util.StringUtil;

public class HttpcURLNormBuilder {
    public static int orgUrlNormHash = 0;
    public static String orgTraceHttpcNormUrls = "_none_";
    static Configure conf = Configure.getInstance();
    public static UrlNormMap urlNormMap = new UrlNormMap();
    public static boolean firstBuildDone = false;

    public static void start() {
        if (ConfDebug.debug_urlnorm) {
            Logger.green("HttpCUrlNorm HttpcUrlNormalizer.start()");
        }
        try {
            HttpcURLNormBuilder.buildPrefixs();
            HttpcURLNormBuilder.buildPatterns("Start");
            ConfObserver.add(HttpcUrlNorm.class.getName(), new Runnable(){

                public void run() {
                    HttpcURLNormBuilder.buildPrefixs();
                    HttpcURLNormBuilder.buildPatterns("ConfigUpdate");
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void buildPrefixs() {
        if (HttpcURLPrefix.prefix.url_prefix == HttpcURLNormBuilder.conf.trace_httpc_normalize_prefix) {
            return;
        }
        if (!CompareUtil.equals(HttpcURLPrefix.prefix.url_prefix, HttpcURLNormBuilder.conf.trace_httpc_normalize_prefix)) {
            HttpcURLPrefix.build(HttpcURLNormBuilder.conf.trace_httpc_normalize_prefix);
        }
        HttpcURLPrefix.prefix.url_prefix = HttpcURLNormBuilder.conf.trace_httpc_normalize_prefix;
    }

    public static void buildPatterns(String execBy) {
        if (orgTraceHttpcNormUrls == HttpcURLNormBuilder.conf.trace_httpc_normalize_urls && HttpcURLNormBuilder.isSameUrlNorm()) {
            return;
        }
        if (!CompareUtil.equals(orgTraceHttpcNormUrls, HttpcURLNormBuilder.conf.trace_httpc_normalize_urls) || !HttpcURLNormBuilder.isSameUrlNorm()) {
            HttpcURLNormBuilder.build(execBy);
        }
        orgTraceHttpcNormUrls = HttpcURLNormBuilder.conf.trace_httpc_normalize_urls;
    }

    public static void build(String execBy) {
        firstBuildDone = true;
        orgTraceHttpcNormUrls = HttpcURLNormBuilder.conf.trace_httpc_normalize_urls;
        HttpcURLNormProxy.noNeedSet.clear();
        HttpcURLNormProxy.parsedSet.clear();
        UrlPathTree pathTreeTmp = new UrlPathTree();
        Object[] urlArr = StringUtil.tokenizer(orgTraceHttpcNormUrls, ",");
        if (!ArrayUtil.isEmpty(urlArr)) {
            for (Object path : urlArr) {
                if (StringUtil.isEmpty((String)path)) continue;
                pathTreeTmp.insert((String)path);
            }
        }
        if (!ArrayUtil.isEmpty(urlArr = urlNormMap.getUrls())) {
            for (Object u : urlArr) {
                if (u != null && ((String)u).indexOf("{") >= 0) {
                    pathTreeTmp.insert((String)u);
                    continue;
                }
                HttpcURLNormProxy.noNeedSet.put(((String)u).hashCode());
            }
        }
        orgUrlNormHash = urlNormMap.getUrlsHash();
        HttpcURLNormProxy.num_of_urls = pathTreeTmp.size();
        HttpcURLNormProxy.urlPathTree = pathTreeTmp.pathTree;
        Logger.println("HttpcUrlNorm", AnsiPrint.green("PathTree build done. ") + "BuildBy=" + execBy + AnsiPrint.green(" PathTree=" + pathTreeTmp.size()));
        if (ConfDebug.debug_urlnorm) {
            int n = 0;
            Enumeration<String> en = pathTreeTmp.values();
            while (en.hasMoreElements()) {
                String ent = en.nextElement();
                if (StringUtil.isEmpty(ent)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("    ");
                sb.append(n++).append(": ").append(ent).append("\n");
                Logger.write(AnsiPrint.yellow(sb.toString()));
            }
        }
    }

    public static boolean isSameUrlNorm() {
        return urlNormMap.getUrlsHash() == orgUrlNormHash;
    }
}

