/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.trace;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.io.DataInputX;
import whatap.util.BitUtil;
import whatap.util.IPUtil;
import whatap.util.LongKeyLinkedMap;
import whatap.util.ThreadUtil;

public class SocketTable {
    private static Configure conf = Configure.getInstance();
    public static LongKeyLinkedMap<Info> socketMap = new LongKeyLinkedMap().setMax(1024);
    private static long last_log = 0L;

    private static void stackLog(byte[] ipaddr, int port) {
        long now = System.currentTimeMillis();
        if (now - last_log >= 5000L) {
            last_log = now;
            Logger.info(IPUtil.toString(ipaddr) + ":" + port, ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 3));
        }
    }

    public static void add(byte[] ipaddr, int port, int serviceHash, long txid) {
        long key = SocketTable.mkey(ipaddr, port);
        Info info = socketMap.get(key);
        if (info != null) {
            if (info.stackOrder) {
                info.service = serviceHash;
                info.txid = txid;
                info.updateTime = System.currentTimeMillis();
                info.stackOrder = false;
                info.stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 3);
            }
            if (info.service == 0) {
                info.service = serviceHash;
                info.txid = txid;
                info.updateTime = System.currentTimeMillis();
            }
            ++info.count;
        } else {
            info = new Info(serviceHash, txid);
            socketMap.put(key, info);
            if (SocketTable.conf.hasSocketOpenStackPort && SocketTable.conf.socket_open_stack_port.contains(port)) {
                info.stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 3);
            }
        }
    }

    private static long mkey(byte[] ipaddr, int port) {
        if (ipaddr == null) {
            return port;
        }
        return BitUtil.composite(DataInputX.toInt(ipaddr, 0), port);
    }

    public static class Info {
        public int service;
        public long txid;
        public long updateTime;
        public boolean stackOrder = false;
        public String stack;
        public long count = 1L;

        public Info(int service, long txid) {
            this.service = service;
            this.txid = txid;
            this.updateTime = System.currentTimeMillis();
        }
    }
}

