/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.ZipPackThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.SqlRec;
import whatap.lang.pack.StatSqlPack;
import whatap.lang.var.I3;
import whatap.util.LinkedMap;

public class StatSql {
    private static StatSql instance;
    private final int TABLE_MAX_SIZE = 5000;
    private final LinkedMap<I3, SqlRec> table = new LinkedMap<I3, SqlRec>(5001, 1.0f){

        @Override
        protected SqlRec create(I3 key) {
            if (this.isFull()) {
                return null;
            }
            int urlHash = key.v1;
            int dbc = key.v2;
            int sql = key.v3;
            SqlRec rec = new SqlRec();
            rec.setDbcSql(urlHash, dbc, sql);
            rec.time_min = Integer.MAX_VALUE;
            return rec;
        }
    }.setMax(5000);
    protected Configure conf = Configure.getInstance();

    public static synchronized StatSql getInstance() {
        if (instance == null) {
            instance = new StatSql();
        }
        return instance;
    }

    public StatSql() {
        this.table.setMax(ConfStat.stat_sql_max_count);
        ConfObserver.add("StatSql", new Runnable(){

            public void run() {
                StatSql.this.table.setMax(ConfStat.stat_sql_max_count);
            }
        });
    }

    protected SqlRec getSql(int urlHash, int dbc, int sql) {
        return this.table.intern(new I3(urlHash, dbc, sql));
    }

    public void addFetch(int urlHash, int dbc, int sql, int fetch, int fetchTime) {
        SqlRec r = this.getSql(urlHash, dbc, sql);
        if (r != null) {
            r.fetch_count += (long)fetch;
            r.fetch_time += (long)fetchTime;
        }
    }

    public void addUpdate(int urlHash, int dbc, int sql, int updated) {
        if (sql == 0) {
            return;
        }
        SqlRec r2 = this.getSql(urlHash, dbc, sql);
        if (r2 != null) {
            r2.update_count += (long)updated;
        }
    }

    public void addSqlActive(int dbc, int sql) {
    }

    public void addSqlTime(int urlHash, int dbc, int sql, int time, boolean isErr) {
        SqlRec sqlRec;
        if (sql != 0 && (sqlRec = this.getSql(urlHash, dbc, sql)) != null) {
            ++sqlRec.count_total;
            sqlRec.time_sum += (long)time;
            sqlRec.time_sqr_sum += (long)time * (long)time;
            sqlRec.time_min = Math.min(sqlRec.time_min, time);
            sqlRec.time_max = Math.max(sqlRec.time_max, time);
            if (isErr) {
                ++sqlRec.count_error;
            }
            sqlRec.service = urlHash;
        }
    }

    public void addSqlTime(int urlHash, long txid, int dbc, int sql, int time, boolean isErr) {
        SqlRec sqlRec;
        if (sql != 0 && (sqlRec = this.getSql(urlHash, dbc, sql)) != null) {
            ++sqlRec.count_total;
            sqlRec.time_sum += (long)time;
            sqlRec.time_sqr_sum += (long)time * (long)time;
            sqlRec.time_min = Math.min(sqlRec.time_min, time);
            if (sqlRec.time_max <= time) {
                sqlRec.time_max = time;
                sqlRec.service = urlHash;
                sqlRec.txid_slowest = txid;
            }
            if (isErr) {
                ++sqlRec.count_error;
                sqlRec.txid_error = txid;
            }
        }
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatSqlPack p;
            ArrayList<SqlRec> out = new ArrayList<SqlRec>(this.table.size() + 10);
            Enumeration<SqlRec> en = this.table.values();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            this.table.clear();
            if (ConfStat.stat_1m_enabled) {
                p = new StatSqlPack(2561);
                p.dataStartTime = now - 60000L;
            } else {
                p = new StatSqlPack();
            }
            p.setRecords(out, ConfStat.stat_sql_v2_enabled);
            p.time = now;
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(p);
            } else {
                DataPackSender.send(p);
            }
        }
        catch (Exception e) {
            Logger.println("A199", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

