/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShellArg {
    private Map<String, LinkedHashSet<String>> parameter = new HashMap<String, LinkedHashSet<String>>();
    private Map<String, Boolean> cmds = new HashMap<String, Boolean>();

    public ShellArg(String[] args) {
        boolean isDebugParam = false;
        boolean isErrorParam = false;
        boolean isRemoveParam = false;
        String key = null;
        String value = null;
        int i = 0;
        LinkedHashSet<String> params = null;
        this.cmds.put("help", false);
        this.cmds.put("list", false);
        this.cmds.put("remove", false);
        this.cmds.put("debug", false);
        this.cmds.put("error", false);
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                key = args[i].substring(1);
                if (key == null) {
                    ++i;
                    continue;
                }
                if (this.isHelpKey(key)) {
                    this.cmds.put("help", true);
                    return;
                }
                if (this.isListKey(key)) {
                    this.cmds.put("list", true);
                    return;
                }
                if (this.isDebugKey(key)) {
                    this.cmds.put("debug", true);
                    isDebugParam = true;
                    isRemoveParam = false;
                }
                if (this.isErrorKey(key)) {
                    this.cmds.put("error", true);
                    isErrorParam = true;
                    isRemoveParam = false;
                }
                if (this.isRemoveKey(key)) {
                    params = new LinkedHashSet<String>();
                    this.parameter.put("remove", params);
                    this.cmds.put("remove", true);
                    isRemoveParam = true;
                    isDebugParam = false;
                }
                ++i;
                continue;
            }
            value = args[i];
            if (isRemoveParam) {
                if (value == null || value.length() == 0) {
                    ++i;
                    continue;
                }
                params.add(value);
                value = null;
            }
            if (isDebugParam || isErrorParam) {
                ++i;
                continue;
            }
            ++i;
        }
    }

    private boolean isHelpKey(String key) {
        return "h".equals(key) || "help".equals(key);
    }

    private boolean isListKey(String key) {
        return "l".equals(key) || "list".equals(key);
    }

    private boolean isRemoveKey(String key) {
        return "r".equals(key) || "remove".equals(key);
    }

    private boolean isDebugKey(String key) {
        return "d".equals(key) || "debug".equals(key);
    }

    private boolean isErrorKey(String key) {
        return "e".equals(key) || "error".equals(key);
    }

    public LinkedHashSet<String> getRemoveSet(String key) {
        return this.parameter.get(key);
    }

    public boolean getError(String key) {
        return this.cmds.get(key);
    }

    public boolean getDebug(String key) {
        return this.cmds.get(key);
    }

    public boolean getHelp(String key) {
        return this.cmds.get(key);
    }

    public boolean getList(String key) {
        return this.cmds.get(key);
    }

    public boolean getRemove(String key) {
        return this.cmds.get(key);
    }
}

