/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;

public class EncodingTool {
    public static void main(String[] args) throws Exception {
        ShellArg ar = new ShellArg(args);
        System.out.println();
        System.out.println(AnsiPrint.green("\tfile.encoding=" + System.getProperty("file.encoding")));
        System.out.println();
        String file = ar.get("-f");
        if (file == null) {
            EncodingTool.usage();
            return;
        }
        String enc = ar.get("-enc");
        if (enc != null) {
            EncodingTool.print(file, enc);
            return;
        }
        String enc1 = ar.get("-enc1");
        String enc2 = ar.get("-enc2");
        String enc3 = ar.get("-enc3");
        if (enc1 != null && enc2 != null && enc3 != null) {
            EncodingTool.print(file, enc1, enc2, enc3);
            return;
        }
        EncodingTool.usage();
    }

    private static void print(String file, String enc) {
        File ff = new File(file);
        if (!ff.exists()) {
            System.out.println("can't read " + ff);
            EncodingTool.usage();
            return;
        }
        byte[] b = FileUtil.readAll(ff);
        String s = new String(enc);
        System.out.println(AnsiPrint.yellow("Result(" + enc + "): ") + s);
    }

    private static void print(String file, String enc1, String enc2, String enc3) throws Exception {
        File ff = new File(file);
        if (!ff.exists()) {
            System.out.println("can't read " + ff);
            EncodingTool.usage();
            return;
        }
        byte[] b = FileUtil.readAll(ff);
        String s = new String(enc1);
        System.out.println(AnsiPrint.yellow("Result(" + enc1 + "): ") + s);
        byte[] b2 = s.getBytes(enc2);
        String s2 = new String(enc3);
        System.out.println(AnsiPrint.yellow("Result(String(" + enc1 + ")->getBytes(" + enc2 + ")->String(" + enc3 + ")): ") + s2);
    }

    private static void usage() {
        System.out.println("java -cp " + JarUtil.getThisJarName(EncodingTool.class) + " " + EncodingTool.class.getName());
        System.out.println("\t  -f data");
        System.out.println("\t  -enc EUC-KR ");
        System.out.println("\t  -enc1 8859_1 -enc2 " + System.getProperty("file.encoding") + " -enc3 UTF8");
        System.exit(1);
    }
}

