/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.CypherConf;
import whatap.agent.data.DataPackSender;
import whatap.agent.net.TcpRequestMgr;
import whatap.agent.net.TcpSession;
import whatap.io.DataOutputX;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.EventPack;
import whatap.lang.pack.TextPack;
import whatap.net.NetFlag;
import whatap.util.ThreadUtil;

public class Sender
extends Thread {
    Configure conf = Configure.getInstance();
    static long last_time_sync = 0L;
    static long last_log = System.currentTimeMillis();

    public Sender() {
        this.setDaemon(true);
    }

    public void run() {
        SecurityMaster secu = SecurityMaster.getInstance();
        TcpRequestMgr mgr = TcpRequestMgr.getInstance();
        TcpSession tcpSession = TcpSession.getInstance();
        int cypher_level = this.conf.cypher_level;
        while (true) {
            TcpRequestMgr.Data data = mgr.queue.get();
            while (!tcpSession.isOpen()) {
                ThreadUtil.sleep(100L);
            }
            if (cypher_level != this.conf.cypher_level) {
                cypher_level = this.conf.cypher_level;
                tcpSession.close();
                continue;
            }
            int len = 0;
            try {
                long now;
                if (this.conf.time_sync_enabled && (now = System.currentTimeMillis()) > last_time_sync + this.conf.time_sync_interval_ms) {
                    last_time_sync = now;
                    tcpSession.send((byte)-2, true, (short)0, DataOutputX.toBytes(now));
                }
                if (data.flag == 4) {
                    byte[] b = DataOutputX.toBytes(data.pack);
                    len = b.length;
                    if (len <= this.conf.net_send_max_bytes) {
                        tcpSession.sendOneWay(data.pack.pcode, b, data.flush);
                        continue;
                    }
                    Sender.handleOverflow(data.pack, len);
                    continue;
                }
                if (data.pack.oid == 0) {
                    if (secu.OID == 0) continue;
                    data.pack.oid = secu.OID;
                }
                if (this.conf.cypher_level == 0) {
                    byte[] b = DataOutputX.toBytes(data.pack);
                    len = b.length;
                    if (len <= this.conf.net_send_max_bytes) {
                        tcpSession.send(data.flag, data.flush, data.pack.getPackType(), b);
                    }
                } else {
                    switch (NetFlag.getSecureMask(data.flag)) {
                        case 1: {
                            if (CypherConf.cypher == null) break;
                            byte[] b = DataOutputX.toBytes(data.pack);
                            len = (b = CypherConf.cypher.hide(b)).length;
                            if (len > this.conf.net_send_max_bytes) break;
                            tcpSession.send(data.flag, data.flush, data.pack.getPackType(), b);
                            break;
                        }
                        case 2: {
                            if (CypherConf.cypher == null) break;
                            byte[] b = DataOutputX.toBytes(data.pack, this.conf.cypher_level / 8);
                            len = (b = CypherConf.cypher.encryptBlock(b)).length;
                            if (len > this.conf.net_send_max_bytes) break;
                            tcpSession.send(data.flag, data.flush, data.pack.getPackType(), b);
                            break;
                        }
                        default: {
                            byte[] b = DataOutputX.toBytes(data.pack);
                            len = b.length;
                            if (len > this.conf.net_send_max_bytes) break;
                            tcpSession.send(data.flag, data.flush, data.pack.getPackType(), b);
                        }
                    }
                }
                if (len > this.conf.net_send_max_bytes) {
                    Sender.handleOverflow(data.pack, len);
                    continue;
                }
                mgr.sendBytes += (long)len;
                ++mgr.sendPack;
                continue;
            }
            catch (Throwable t) {
                Logger.println("A117", 10, t);
                continue;
            }
            break;
        }
    }

    public static void handleOverflow(AbstractPack pack, int len) {
        if (Configure.getInstance().overflow_log_enabled) {
            Sender.logOverflow(pack, len);
        }
        if (Configure.getInstance().overflow_event_enabled) {
            Sender.alertOverflow(pack, len);
        }
    }

    public static void logOverflow(AbstractPack pack, int len) {
        long now = System.currentTimeMillis();
        if (now - last_log < 10000L) {
            return;
        }
        last_log = now;
        if (pack.getPackType() == 1792) {
            TextPack p = (TextPack)pack;
            int sz = p.records.size();
            Logger.println(pack.toSimpleString() + " len=" + len + " rec=" + sz);
            String msg = sz == 0 ? "" : p.records.get((int)0).text.toString(1024);
            Logger.println("overflow", msg);
        } else {
            Logger.println("overflow", pack.toSimpleString() + " len=" + len);
        }
    }

    private static void alertOverflow(AbstractPack pack, int len) {
        long now = System.currentTimeMillis();
        if (now - last_log < 10000L) {
            return;
        }
        last_log = now;
        String message = pack.getClass().getName() + "(len=" + len + ")";
        EventPack e = new EventPack();
        e.level = (byte)10;
        e.title = "NEW_OVERFLOW";
        e.status = 1;
        e.message = "Too big data: " + message;
        DataPackSender.send(e);
    }
}

