/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import whatap.agent.Configure;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfTrace;
import whatap.agent.data.ZipProfileThread;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.ProfileStepSplitPack;
import whatap.lang.step.Step;
import whatap.util.RequestQueue;

public class ProfileStepThread
extends Thread {
    private static ProfileStepThread instance;
    RequestQueue<StepSplit> queue = new RequestQueue(ConfTrace.trace_txsplit_queue_size);
    private long drop;
    static SecurityMaster secuMaster;
    static Configure conf;

    public static final synchronized ProfileStepThread getInstance() {
        if (instance == null) {
            instance = new ProfileStepThread();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    private ProfileStepThread() {
        ConfObserver.add("ProfileStepThread", new Runnable(){

            public void run() {
                ProfileStepThread.this.queue.setCapacity(ConfTrace.trace_txsplit_queue_size);
            }
        });
    }

    public void add(long time, long txid, int inx, Step[] steps) {
        this.queue.put(new StepSplit(time, txid, inx, steps));
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    StepSplit log = this.queue.get();
                    ProfileStepSplitPack p = new ProfileStepSplitPack();
                    p.pcode = ProfileStepThread.secuMaster.PCODE;
                    p.oid = ProfileStepThread.secuMaster.OID;
                    p.time = log.time;
                    p.txid = log.txid;
                    p.inx = log.inx;
                    p.steps = Step.toBytes(log.steps);
                    ZipProfileThread.getInstance().add(p);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    static {
        secuMaster = SecurityMaster.getInstance();
        conf = Configure.getInstance();
    }

    static class StepSplit {
        long time;
        long txid;
        int inx;
        Step[] steps;

        public StepSplit(long time, long txid, int inx, Step[] steps) {
            this.time = time;
            this.txid = txid;
            this.inx = inx;
            this.steps = steps;
        }
    }
}

