/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import whatap.agent.Configure;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.MeterActiveX;
import whatap.agent.counter.meter.MeterSQL;
import whatap.lang.pack.CounterPack1;
import whatap.util.IntEnumer;
import whatap.util.IntKeyLinkedMap;

public class ServiceSql
implements ICounterTask {
    private long stime = System.currentTimeMillis();

    public void process(CounterPack1 p) {
        MeterSQL.Bucket sql = MeterSQL.getInstance().getBucketReset();
        p.sql_time_sum = sql.time;
        p.sql_count = sql.count;
        p.sql_error = sql.error;
        p.sql_fetch_count = sql.fetch_count;
        p.sql_fetch_time_sum = sql.fetch_time;
        long now = System.currentTimeMillis();
        long dtime = now - this.stime;
        if (dtime == 0L) {
            return;
        }
        this.stime = now;
        if (Configure.getInstance().sql_dbc_meter_enabled) {
            this.sql_meter(p);
        }
        if (Configure.getInstance().actx_meter_enabled) {
            this.sql_actx_meter(p);
        }
    }

    public void sql_meter(CounterPack1 p) {
        MeterSQL meter = MeterSQL.getInstance();
        if (meter.stat.size() > 0) {
            p.sql_meter = new IntKeyLinkedMap();
            IntEnumer en = meter.stat.keys();
            for (int i = 0; i < 100 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                MeterSQL.Bucket b = meter.stat.get(key);
                CounterPack1.SqlMeter m = new CounterPack1.SqlMeter();
                m.time = b.time;
                m.count = b.count;
                m.error = b.error;
                m.fetch_count = b.fetch_count;
                m.fetch_time = b.fetch_time;
                p.sql_meter.put(key, m);
            }
            meter.resetStat();
        }
    }

    private void sql_actx_meter(CounterPack1 p) {
        MeterActiveX meter = MeterActiveX.getInstance();
        IntKeyLinkedMap<short[]> m = meter.act_sql_slice;
        if (m != null && m.size() > 0) {
            if (p.sql_meter == null) {
                p.sql_meter = new IntKeyLinkedMap();
            }
            IntEnumer en = m.keys();
            for (int i = 0; i < 300 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                CounterPack1.SqlMeter sqlMeter = p.sql_meter.get(key);
                if (sqlMeter == null) {
                    sqlMeter = new CounterPack1.SqlMeter();
                    p.sql_meter.put(key, sqlMeter);
                }
                sqlMeter.acts = m.get(key);
            }
        }
    }
}

