/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.profile;

import whatap.agent.control.profile.DynaHook;
import whatap.agent.control.profile.DynaMethodProfile;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.ListValue;
import whatap.util.StringUtil;

public class DynaProfileControl {
    public static final DynaMethodProfile methodProfile = new DynaMethodProfile();
    public static final DynaMethodProfile capArgProfile = new DynaMethodProfile();
    public static final DynaMethodProfile capReturnProfile = new DynaMethodProfile();

    public static void read(DynaMethodProfile profile, ListValue listVal, String className) {
        DynaHook h = profile.getDyna(className);
        if (h == null || h.stat == 0 || h.stat == 2) {
            listVal.add("");
        } else if (h.isAll) {
            listVal.add("*");
        } else {
            listVal.add(h.toConfig());
        }
    }

    public static void updateMethod(String className, String config) {
        DynaProfileControl.update(methodProfile, className, StringUtil.trim(config));
    }

    public static void updateArg(String className, String config) {
        DynaProfileControl.update(capArgProfile, className, StringUtil.trim(config));
    }

    public static void updateReturn(String className, String config) {
        DynaProfileControl.update(capReturnProfile, className, StringUtil.trim(config));
    }

    public static void update(DynaMethodProfile profile, String className, String opt) {
        className = StringUtil.trim(className);
        opt = StringUtil.trim(opt);
        DynaHook h = profile.getDyna(className);
        if (StringUtil.isEmpty(opt) || "-".equals(opt)) {
            if (h != null && h.stat != 0) {
                h.stat = (byte)2;
            }
        } else {
            h = profile.newDyna(className);
            h.put(opt);
            h.stat = 1;
        }
    }

    public static void apply(ParamPack p) {
        String msg = methodProfile.apply();
        p.put("result_method", msg);
        msg = capArgProfile.apply();
        p.put("result_arg", msg);
        msg = capReturnProfile.apply();
        p.put("result_return", msg);
    }
}

