/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.ParamSecurity;
import whatap.agent.conf.ConfDebug;
import whatap.agent.conf.ConfTrace;
import whatap.agent.control.ActiveDBTxForSID;
import whatap.agent.control.ActiveTx;
import whatap.agent.control.AgentDataHelp;
import whatap.agent.control.AgentHeapDump;
import whatap.agent.control.ClassCtrHelper;
import whatap.agent.control.CmdConfig;
import whatap.agent.control.SocketHelper;
import whatap.agent.control.ds.ConnPoolStatusProxy;
import whatap.agent.control.dyna.DynaBCIHelper;
import whatap.agent.control.dyna.DynaBCIMethod;
import whatap.agent.control.dyna.DynaBCIService;
import whatap.agent.control.exec.AgentExec;
import whatap.agent.control.profile.DynaMethodProfile;
import whatap.agent.control.profile.DynaProfileControl;
import whatap.agent.counter.collection.CollectionHolder;
import whatap.agent.counter.meter.BlockingDetect;
import whatap.agent.counter.meter.ThreadDump;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.proxy.ToolsMainFactory;
import whatap.agent.topology.StatusDetector;
import whatap.agent.trace.MethodStat;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.httpc.urlnorm.HttpcURLNormBuilder;
import whatap.agent.trace.sql.DBType;
import whatap.agent.trace.urlnorm.UrlNormPathTreeBuilder;
import whatap.agent.util.HomeUtil;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.conf.ConfigMake;
import whatap.lang.pack.Pack;
import whatap.lang.pack.ParamPack;
import whatap.lang.value.BlobValue;
import whatap.lang.value.BooleanValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.TextValue;
import whatap.util.CastUtil;
import whatap.util.DateUtil;
import whatap.util.RequestQueue;
import whatap.util.SortUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlHandler
extends Thread {
    private static ControlHandler instance;
    private RequestQueue<Pack> queue = new RequestQueue(100);
    Configure conf = Configure.getInstance();

    public static final synchronized ControlHandler getInstance() {
        if (instance == null) {
            instance = new ControlHandler();
            instance.setDaemon(true);
            ThreadNameUtil.whatap(instance);
            instance.start();
        }
        return instance;
    }

    public void add(Pack p) {
        this.queue.put(p);
    }

    @Override
    public void run() {
        while (true) {
            Pack p = this.queue.get();
            try {
                this.process(p);
                continue;
            }
            catch (Throwable t) {
                Logger.println("A220", 10, t);
                continue;
            }
            break;
        }
    }

    private void process(Pack p) {
        switch (p.getPackType()) {
            case 256: {
                if (this.conf.debug_param_pack_enabled) {
                    Logger.println("ParamPack", ((ParamPack)p).toFormatString());
                }
                this.handle((ParamPack)p);
                break;
            }
            default: {
                Logger.println("A221", 10, p);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handle(ParamPack p) {
        switch (p.id) {
            case 1: {
                if (!this.conf.debug_param_keepalive_pack_enabled) break;
                Logger.println("KEEPALIVE RECV TIME : " + DateUtil.ymdhms(DateUtil.currentTime()));
                break;
            }
            case 4: {
                m = CmdConfig.readConfig();
                p.setMapValue(m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 7: {
                m = ThreadUtil.getThreadList();
                p.put("thread_list", m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 8: {
                threadId = p.getLong("thread_id");
                m = ThreadUtil.getThreadDetail(threadId);
                p.put("" + threadId, m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 9: {
                thread_id = p.getLong("thread_id");
                txid = p.getLong("txid");
                if (txid == 0L) {
                    txid = p.getLong("profile_seq");
                }
                m = new MapValue();
                stack = ActiveTx.getCallStackOnly(txid);
                m.put("callstack", stack);
                p.put("" + thread_id, m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 25: {
                maxcount = p.getInt("maxcount");
                mintime = p.getInt("mintime");
                appctx = p.getText("appctx");
                m = ActiveTx.getActiveTxList(mintime, maxcount, appctx);
                p.put("active", m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 26: {
                txid = p.getLong("txid");
                if (txid == 0L) {
                    txid = p.getLong("profile");
                }
                m = ActiveTx.getActiveTxDetail(txid);
                p.put("detail", m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 46: {
                dbtype = p.getText("dbtype");
                sid = CastUtil.cint(p.get("sid"));
                serial = CastUtil.cint(p.get("serial"));
                inst = CastUtil.cint(p.get("inst"));
                dbtypeCode = DBType.getDBCodeForDBName(dbtype);
                m = ActiveDBTxForSID.getActiveTxList(dbtypeCode, sid, serial, inst);
                if (m != null) {
                    p.put("detail", m);
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 10: {
                filter = p.getText("filter");
                try {
                    m = ToolsMainFactory.heaphisto(filter);
                    p.put("heaphisto", m);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 37: {
                try {
                    ToolsMainFactory.threadDump(p);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 11: {
                filter = p.getText("filter");
                try {
                    m = ClassCtrHelper.getLoadedClassList(filter);
                    p.put("classlist", m);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 16: {
                isBytes = p.getBoolean("is_body");
                detail = p.getBoolean("detail");
                classname = p.getText("classname");
                isWhatap = classname != null && classname.startsWith("whatap.") != false;
                try {
                    if (isBytes && !isWhatap) {
                        m = ClassCtrHelper.getClassInfoBin(classname, detail);
                        if (m != null) {
                            p.put("class", m.txt);
                            if (m.bytes != null) {
                                p.put("bytes", new BlobValue(m.bytes));
                            }
                        }
                    } else {
                        m = ClassCtrHelper.getClassInfo(classname, detail);
                        p.put("class", m);
                    }
                }
                catch (Throwable t) {
                    Logger.println("LOADED_CLASS_DETAIL", 10000, t);
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 17: {
                conf = Configure.getInstance();
                classname = p.getText("classname");
                hook_method = StringUtil.cutOut(p.getText("profile"), "(");
                if (StringUtil.isNotEmpty(hook_method)) {
                    if (ConfTrace.trace_from_stack_enabled) {
                        p.put("error", "Profile-from-stack, not allowed");
                        DataPackSender.sendResponseHide(p.reponse());
                        break;
                    }
                    ok = ConfigMake.addProfile(conf.getPropertyFile(), "hook_method_patterns", hook_method);
                    if (ok) {
                        conf.reload();
                    }
                    classname = StringUtil.cutOut(hook_method, ".");
                }
                try {
                    error = ClassCtrHelper.getClassRedefine(classname);
                    if (error != null) {
                        p.put("error", error);
                    } else {
                        p.put("message", "ok");
                    }
                }
                catch (Throwable t) {
                    Logger.println("redefine: " + classname + " " + t);
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 12: {
                try {
                    m = this.getenv();
                    p.put("env", m);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 13: {
                try {
                    rt = Runtime.getRuntime();
                    total1 = rt.totalMemory();
                    used1 = total1 - rt.freeMemory();
                    System.gc();
                    total2 = rt.totalMemory();
                    used2 = total2 - rt.freeMemory();
                    m = new MapValue();
                    m.put("before-t", total1);
                    m.put("before-u", used1);
                    m.put("after-t", total2);
                    m.put("after-u", used2);
                    p.put("gc", m);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 38: {
                try {
                    cmd = p.getText("cmd");
                    if (cmd != null && cmd.equals("dump")) {
                        if (Configure.getInstance().heapdump_enabled) {
                            error = AgentHeapDump.callHeapDump(p);
                            if (error != null) {
                                p.put("error", error);
                            }
                        } else {
                            p.put("error", "heap dump disabled");
                        }
                    } else if (cmd != null && cmd.equals("list")) {
                        list = AgentHeapDump.listHeapDump();
                        p.put("files", list);
                        p.put("ok", new BooleanValue(true));
                    }
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 14: {
                try {
                    conf = Configure.getInstance();
                    map = (MapValue)p.get("config");
                    if (map != null) {
                        removes = new ArrayList<String>();
                        keys = new ArrayList<String>();
                        values = new ArrayList<String>();
                        en = map.keys();
                        while (en.hasMoreElements()) {
                            key = en.nextString();
                            value = map.getText(key);
                            if (StringUtil.isEmpty(value)) {
                                removes.add(key);
                                continue;
                            }
                            keys.add(key);
                            values.add(value);
                        }
                        ConfigMake.reset(conf.getPropertyFile(), keys, values, removes);
                    }
                    map = ConfigMake.load(conf.getPropertyFile());
                    p.put("config", map);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 15: {
                list = p.getList("sockets");
                cmd = p.getText("cmd");
                try {
                    if (cmd != null && list != null) {
                        if ("set".equals(cmd)) {
                            SocketHelper.setStackOrder(list);
                        } else if ("unset".equals(cmd)) {
                            SocketHelper.unsetStackOrder(list);
                        } else if ("clear".equals(cmd)) {
                            SocketHelper.clearStack(list);
                        }
                    }
                    if ((m = SocketHelper.getSocketList()) != null) {
                        p.put("order", m);
                    }
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 18: {
                try {
                    jarSet = HomeUtil.getTraceJarFiles();
                    p.put("files", new ListValue().add(jarSet));
                    p.put("ok", new BooleanValue(true));
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 20: {
                try {
                    jarName = p.getText("file");
                    if (jarName != null) {
                        HomeUtil.delete(jarName);
                    }
                    p.put("ok", new BooleanValue(true));
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 19: {
                try {
                    file = p.getText("file");
                    pos = p.getLong("pos");
                    v = p.get("data");
                    size = p.getLong("size");
                    crc = p.getInt("crc");
                    if (file != null && v != null && v.getValueType() == 60) {
                        data = ((BlobValue)v).value;
                        HomeUtil.save(file, pos, data);
                        p.put("ok", new BooleanValue(true));
                    } else if (crc != 0 && size > 0L && v == null) {
                        HomeUtil.done(file, size, crc);
                        p.put("ok", new BooleanValue(true));
                    } else {
                        p.put("error", "invalid data");
                    }
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 21: {
                DataTextAgent.getInstance().reset();
                break;
            }
            case 22: {
                names = Logger.getLogFiles();
                p.put("files", names);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 23: {
                file = p.getText("file");
                endpos = p.getLong("pos");
                length = p.getLong("length");
                length = Math.min(length, 8000L);
                log = Logger.read(file, endpos, length);
                if (log != null) {
                    p.put("before", log.before);
                    p.put("next", log.next);
                    p.put("text", log.text);
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 31: {
                names = ThreadDump.getDumpFiles();
                p.put("files", names);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 32: {
                file = p.getText("file");
                log = ThreadDump.read(file);
                if (log != null) {
                    p.put("text", log);
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 301: {
                context = p.getText("context");
                name = p.getText("name");
                key = p.getText("key");
                m = ConnPoolStatusProxy.getDataSourceInfo(context, name, key);
                if (m != null) {
                    p.put("result", m);
                    p.put("ok", new BooleanValue(true));
                } else {
                    p.put("error", "not supported");
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 24: {
                threadId = p.getLong("thread_id");
                skey = p.getText("skey");
                status = 500;
                if (!ParamSecurity.isSafeThreadKill(skey)) ** GOTO lbl416
                action = p.getText("action");
                try {
                    ctx = TraceContextManager.findThread(threadId);
                    if (ctx == null || ctx.thread == null) ** GOTO lbl411
                    if ("interrupt".equalsIgnoreCase(action)) {
                        ctx.thread.interrupt();
                        ThreadUtil.sleep(1000L);
                        status = 200;
                    } else if ("stop".equalsIgnoreCase(action)) {
                        msg = "THREAD STOP id=" + ctx.thread.getId() + " name=" + ctx.thread.getName();
                        Logger.println(msg);
                        ctx.thread.stop();
                        ThreadUtil.sleep(1000L);
                        status = 200;
                    } else if ("resume".equalsIgnoreCase(action)) {
                        ctx.thread.resume();
                        ThreadUtil.sleep(1000L);
                        status = 200;
                    } else if ("suspend".equalsIgnoreCase(action)) {
                        ctx.thread.suspend();
                        ThreadUtil.sleep(1000L);
                        status = 200;
                    } else {
                        status = 204;
                    }
                    ** GOTO lbl417
lbl411:
                    // 1 sources

                    status = 400;
                }
                catch (Throwable t) {
                    status = 500;
                }
                ** GOTO lbl417
lbl416:
                // 1 sources

                status = 401;
lbl417:
                // 8 sources

                m = ThreadUtil.getThreadDetail(threadId);
                m.put("status", status);
                p.put("" + threadId, m);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 27: {
                node = new StatusDetector().process();
                if (node != null) {
                    p.put("node", new BlobValue(node.toBytes()));
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 302: {
                index = p.getInt("index");
                max = p.getInt("max");
                reset = p.getBoolean("reset");
                filter = p.getText("filter");
                table = MethodStat.getEntry(index, max, filter);
                if (table != null) {
                    p.put("result", table);
                }
                if (reset) {
                    MethodStat.reset();
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 303: {
                cmd = p.getText("cmd");
                filter = p.getText("filter");
                if (("get".equals(cmd) || cmd == null) && (table = BlockingDetect.getInstance().getList(filter)) != null) {
                    p.put("result", table);
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 39: {
                break;
            }
            case 105: {
                filter = p.getText("filter");
                try {
                    m = CollectionHolder.getList(filter);
                    p.put("result", m);
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 44: {
                try {
                    type = p.getText("type");
                    if (type == null || "service".equals(type)) {
                        rebuild = p.getBoolean("#rebuild");
                        reset = p.getBoolean("#reset");
                        urls = (ListValue)p.remove("urls");
                        if (urls != null) {
                            if (!reset) {
                                ischanged = UrlNormPathTreeBuilder.urlNormMap.addUrls(urls);
                                if (ConfDebug.debug_urlnorm) {
                                    Logger.green("UrlNorm addUrls() urls=" + urls.size() + " ischanged=" + ischanged + " rebuild=" + rebuild);
                                }
                                if (rebuild || ischanged) {
                                    UrlNormPathTreeBuilder.build("ServerRequest", null);
                                }
                            } else {
                                ischanged = UrlNormPathTreeBuilder.urlNormMap.resetUrls(urls);
                                if (ConfDebug.debug_urlnorm) {
                                    Logger.green("UrlNorm resetUrls() urls=" + urls.size() + " ischanged=" + ischanged + " rebuild=" + rebuild);
                                }
                                if (rebuild || ischanged) {
                                    UrlNormPathTreeBuilder.build("ServerRequest", null);
                                }
                            }
                        }
                        p.put("ok", new BooleanValue(true));
                    } else if ("httpc".equals(type)) {
                        rebuild = p.getBoolean("#rebuild");
                        reset = p.getBoolean("#reset");
                        urls = (ListValue)p.remove("urls");
                        if (urls != null) {
                            if (!reset) {
                                ischanged = HttpcURLNormBuilder.urlNormMap.addUrls(urls);
                                if (ConfDebug.debug_urlnorm) {
                                    Logger.yellow("UrlNorm", "addHttpUrls() urls=" + urls.size() + " ischanged=" + ischanged + " rebuild=" + rebuild);
                                }
                                if (rebuild || ischanged) {
                                    HttpcURLNormBuilder.build("ServerRequest");
                                }
                            } else {
                                ischanged = HttpcURLNormBuilder.urlNormMap.resetUrls(urls);
                                if (ConfDebug.debug_urlnorm) {
                                    Logger.yellow("UrlNorm", "resetHttpcUrls() urls=" + urls.size() + " ischanged=" + ischanged + " rebuild=" + rebuild);
                                }
                                if (rebuild || ischanged) {
                                    HttpcURLNormBuilder.build("ServerRequest");
                                }
                            }
                        }
                        p.put("ok", new BooleanValue(true));
                    } else {
                        p.put("error", "not supported type: " + type);
                    }
                }
                catch (Throwable t) {
                    p.put("error", t.getMessage());
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 110: {
                cmd = p.getText("cmd");
                if ("prepare".equals(cmd)) {
                    try {
                        nameLv = p.getList("class");
                        this.prepare(DynaProfileControl.methodProfile, nameLv, p.getList("trace_method"));
                        this.prepare(DynaProfileControl.capArgProfile, nameLv, p.getList("trace_arg"));
                        this.prepare(DynaProfileControl.capReturnProfile, nameLv, p.getList("trace_return"));
                        p.put("ok", new BooleanValue(true));
                    }
                    catch (Exception e) {
                        p.put("error", e.getMessage());
                    }
                    DataPackSender.sendResponseHide(p.reponse());
                }
                if (!"apply".equals(cmd)) break;
                DynaProfileControl.apply(p);
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 50: {
                cmd = p.getText("cmd");
                if ("get-top".equals(cmd)) {
                    type = p.getText("type");
                    p.clear();
                    p.put("result", DynaBCIHelper.getTopPackage());
                    if ("transaction".equals(type)) {
                        p.put("option", DynaBCIService.option());
                    } else if ("method".equals(type)) {
                        p.put("option", DynaBCIMethod.option());
                    }
                    DataPackSender.sendResponseHide(p.reponse());
                }
                if ("get-package".equals(cmd)) {
                    top = p.getText("top");
                    p.clear();
                    p.put("result", DynaBCIHelper.getPackageList(top));
                    DataPackSender.sendResponseHide(p.reponse());
                }
                if ("get-class".equals(cmd)) {
                    type = p.getText("type");
                    pkg = p.getText("package");
                    p.clear();
                    classMap = this.getClass(type, pkg);
                    if (classMap.size() > 0) {
                        p.put("result", DynaBCIHelper.toMap(classMap));
                    }
                    DataPackSender.sendResponseHide(p.reponse());
                }
                if (!"apply-class".equals(cmd)) break;
                type = p.getText("type");
                option = p.getList("option");
                classes = (MapValue)p.get("classes");
                p.clear();
                if ("transaction".equals(type)) {
                    err = DynaBCIService.apply(classes, option);
                    if (err != null) {
                        p.put("error", err);
                    } else {
                        p.put("result", "ok");
                    }
                } else if ("method".equals(type)) {
                    err = DynaBCIMethod.apply(classes, option);
                    if (err != null) {
                        p.put("error", err);
                    } else {
                        p.put("result", "ok");
                    }
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 701: {
                cmd = p.getText("cmd");
                if ("info".equals(cmd)) {
                    m = AgentDataHelp.getinfo();
                    p.put("data", m);
                    p.put("result", "ok");
                } else if ("env".equals(cmd)) {
                    m = this.getenv();
                    p.put("data", m);
                    p.put("result", "ok");
                }
                DataPackSender.sendResponseHide(p.reponse());
                break;
            }
            case 702: {
                cmd = p.getText("cmd");
                if ("update".equals(cmd)) {
                    AgentExec.update(p.getText("source"));
                    p.clear();
                    p.put("result", "ok");
                } else if ("exec".equals(cmd)) {
                    data = AgentExec.exec(p);
                    p.clear();
                    p.put("data", data);
                    p.put("result", "ok");
                } else {
                    p.clear();
                    p.put("error", "unknown command: " + cmd);
                    p.put("result", "fail");
                }
                DataPackSender.sendResponseHide(p.reponse());
            }
        }
    }

    private MapValue getenv() {
        MapValue m = new MapValue();
        if (this.conf.agent_env_jvm_enabled) {
            String[] keys;
            Properties pp = System.getProperties();
            for (String key : keys = SortUtil.sort_string(pp.keys(), pp.size())) {
                if (this.conf.agent_env_ignore_keys.hasKey(key.toLowerCase())) continue;
                String value = pp.getProperty(key);
                m.put(key, new TextValue(value));
            }
        }
        if (this.conf.agent_env_system_enabled) {
            this.getSysEnv(m);
        }
        if (m.size() == 0) {
            m.put("AgentEnv", "disabled");
        }
        return m;
    }

    private StringKeyLinkedMap<Boolean> getClass(String type, String pkg) {
        StringKeyLinkedMap<Boolean> classMap = DynaBCIHelper.getClassList(pkg);
        if (classMap.size() > 0) {
            if ("transaction".equals(type)) {
                DynaBCIService.update(classMap);
            } else if ("method".equals(type)) {
                DynaBCIMethod.update(classMap);
            }
        }
        return classMap;
    }

    private void prepare(DynaMethodProfile p, ListValue nameLv, ListValue optLv) {
        if (nameLv == null || optLv == null) {
            return;
        }
        for (int i = 0; i < nameLv.size() && i < optLv.size(); ++i) {
            String className = nameLv.getString(i);
            String opt = optLv.getString(i);
            DynaProfileControl.update(p, className, opt);
        }
    }

    private void getSysEnv(MapValue m) {
        try {
            String[] keys;
            Map<String, String> env = System.getenv();
            for (String key : keys = SortUtil.sort_string(env.keySet().iterator(), env.size())) {
                if (this.conf.agent_env_ignore_keys.hasKey(key.toLowerCase())) continue;
                String value = env.get(key);
                m.put("(env) " + key, new TextValue(value));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

