/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassDefinition;
import java.net.URL;
import java.util.ArrayList;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.control.profile.DynaProfileControl;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.org.objectweb.asm.ClassReader;
import whatap.org.objectweb.asm.util.Textifier;
import whatap.org.objectweb.asm.util.TraceClassVisitor;
import whatap.util.BytesClassLoader;
import whatap.util.ClassUtil;
import whatap.util.StringUtil;

public class ClassCtrHelper {
    static String[] startFilter = new String[]{"sun.reflect.", "java.lang.invoke", "jdk.internal", "oshi.", "com.sun.jna", "com.sun.proxy.", "[L"};
    static String[] indexFilter = new String[]{"$$Lambda"};

    public static MapValue getLoadedClassList(String filter) {
        int COUNT_PER_PAGE = 100;
        MapValue p = new MapValue();
        ListValue indexLv = p.newList("index");
        ListValue typeLv = p.newList("type");
        ListValue nameLv = p.newList("name");
        ListValue superClassLv = p.newList("superClass");
        ListValue interfacesLv = p.newList("interfaces");
        ListValue resourceLv = p.newList("resource");
        ListValue classLoaderLv = p.newList("classloader");
        ListValue traceMethodLv = p.newList("trace_method");
        ListValue traceArgLv = p.newList("trace_arg");
        ListValue traceReturnLv = p.newList("trace_return");
        if (JavaAgent.instrumentation == null) {
            return p;
        }
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        if (loadedClasses == null) {
            return p;
        }
        ArrayList<Class> classList = new ArrayList<Class>();
        for (int i = 0; i < loadedClasses.length; ++i) {
            Class clazz = loadedClasses[i];
            String lowerName = clazz.getName().toLowerCase();
            if (StringUtil.isNotEmpty(filter) && !lowerName.contains(filter.toLowerCase()) || ClassCtrHelper.isIgnore(clazz.getName())) continue;
            classList.add(clazz);
            if (classList.size() >= 100) break;
        }
        int totalCount = classList.size();
        int inx = 1;
        for (int i = 0; i < totalCount; ++i) {
            try {
                Class clazz;
                block19: {
                    indexLv.add(inx++);
                    clazz = (Class)classList.get(i);
                    typeLv.add(clazz.isInterface() ? "I" : (clazz.isPrimitive() ? "P" : "C"));
                    nameLv.add(clazz.getName());
                    String superClassName = "";
                    Class superClass = clazz.getSuperclass();
                    if (superClass != null) {
                        superClassName = superClass.getName();
                    }
                    superClassLv.add(superClassName);
                    StringBuffer sb = new StringBuffer();
                    Class<?>[] interfaces = clazz.getInterfaces();
                    if (interfaces != null) {
                        for (int j = 0; j < interfaces.length; ++j) {
                            sb.append(interfaces[j].getName());
                            if (j >= interfaces.length - 1) continue;
                            sb.append(",");
                        }
                    }
                    interfacesLv.add(sb.toString());
                    try {
                        ClassLoader classLoader = clazz.getClassLoader();
                        if (classLoader == null) {
                            classLoader = ClassLoader.getSystemClassLoader();
                            classLoaderLv.add("system");
                        } else if (classLoader instanceof BytesClassLoader) {
                            classLoaderLv.add("whatap");
                        } else {
                            classLoaderLv.add(classLoader.getClass().getName());
                        }
                        String resource = "";
                        try {
                            URL url = classLoader.getResource(clazz.getName().replace('.', '/') + ".class");
                            if (url != null) {
                                resource = url.toString();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        resourceLv.add(resource);
                    }
                    catch (Exception e) {
                        resourceLv.add("");
                        if (classLoaderLv.size() >= resourceLv.size()) break block19;
                        classLoaderLv.add("");
                    }
                }
                if (!clazz.isInterface()) {
                    DynaProfileControl.read(DynaProfileControl.methodProfile, traceMethodLv, clazz.getName());
                    DynaProfileControl.read(DynaProfileControl.capArgProfile, traceArgLv, clazz.getName());
                    DynaProfileControl.read(DynaProfileControl.capReturnProfile, traceReturnLv, clazz.getName());
                    continue;
                }
                traceMethodLv.add("");
                traceArgLv.add("");
                traceReturnLv.add("");
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return p;
    }

    private static boolean isIgnore(String name) {
        int i;
        for (i = 0; i < startFilter.length; ++i) {
            if (!name.startsWith(startFilter[i])) continue;
            return true;
        }
        for (i = 0; i < indexFilter.length; ++i) {
            if (name.indexOf(indexFilter[i]) < 0) continue;
            return true;
        }
        return false;
    }

    public static String getClassInfo(String className, boolean detail) {
        Class clazz = ClassCtrHelper.getClass(className);
        if (clazz == null) {
            throw new RuntimeException("Not found class " + className);
        }
        if (Configure.getInstance().view_class_detail_enabled || detail) {
            try {
                return ClassCtrHelper.printDetail(clazz);
            }
            catch (Throwable t) {
                Logger.println("fail to load " + className + " " + t);
                return ClassUtil.getClassDescription(clazz, false);
            }
        }
        return ClassUtil.getClassDescription(clazz, false);
    }

    public static ClassInfo getClassInfoBin(String className, boolean detail) {
        Class clazz = ClassCtrHelper.getClass(className);
        if (clazz == null) {
            throw new RuntimeException("Not found class " + className);
        }
        ClassInfo o = new ClassInfo();
        o.bytes = ClassUtil.getByteCode(clazz);
        if (Configure.getInstance().view_class_detail_enabled || detail) {
            try {
                o.txt = ClassCtrHelper.printDetail(clazz);
            }
            catch (Throwable t) {
                Logger.println("fail to load " + className + " " + t);
                o.txt = ClassUtil.getClassDescription(clazz, false);
            }
        } else {
            o.txt = ClassUtil.getClassDescription(clazz, false);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String printDetail(Class c) throws Exception {
        StringWriter sw = new StringWriter();
        try {
            TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, new Textifier(), new PrintWriter(sw));
            byte[] classBytes = ClassUtil.getByteCode(c);
            if (classBytes == null) {
                String string = "No class bytes";
                return string;
            }
            new ClassReader(new ByteArrayInputStream(classBytes)).accept(traceClassVisitor, 0);
        }
        finally {
            sw.close();
        }
        return sw.toString();
    }

    private static Class getClass(String className) {
        Class[] loadedClasses;
        for (Class c : loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses()) {
            if (!c.getName().equals(className)) continue;
            return c;
        }
        return null;
    }

    public static String getClassRedefine(String className) {
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>();
        for (Class c : loadedClasses) {
            if (!c.getName().equals(className)) continue;
            byte[] body = ClassUtil.getByteCode(c);
            if (body != null) {
                classDefList.add(new ClassDefinition(c, body));
                continue;
            }
            Logger.println("redefine: " + className + " has no body");
        }
        if (classDefList.size() > 0) {
            ClassDefinition[] cd = classDefList.toArray(new ClassDefinition[classDefList.size()]);
            try {
                JavaAgent.instrumentation.redefineClasses(cd);
                return null;
            }
            catch (Throwable e) {
                Logger.println("redefine: " + className + " " + e);
                return e.toString();
            }
        }
        return "no class redefined";
    }

    static class ClassInfo {
        byte[] bytes;
        String txt;

        ClassInfo() {
        }
    }
}

