/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.util.Comparator;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.ParamSecurity;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.DBType;
import whatap.lang.ThreadStateEnum;
import whatap.lang.step.SqlStepX;
import whatap.lang.value.BlobValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.CompareUtil;
import whatap.util.DateUtil;
import whatap.util.LongKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

public class ActiveTx {
    static Configure conf = Configure.getInstance();

    public static MapValue getActiveTxList(int mintime, int maxcount, String appctx) {
        MapValue out = new MapValue();
        ListValue time = out.newList("time");
        ListValue tx_hash = out.newList("tx_hash");
        ListValue tx_name = out.newList("tx_name");
        ListValue txid = out.newList("txid");
        ListValue profile = out.newList("profile");
        ListValue ip = out.newList("ip");
        ListValue domain = out.newList("domain");
        ListValue userid = out.newList("userid");
        ListValue wclientId = out.newList("wclientId");
        ListValue elapsed = out.newList("elapsed");
        ListValue cputime = out.newList("cputime");
        ListValue malloc = out.newList("malloc");
        ListValue sqlCount = out.newList("sqlCount");
        ListValue sqlTime = out.newList("sqlTime");
        ListValue fetchCount = out.newList("fetchCount");
        ListValue fetchTime = out.newList("fetchTime");
        ListValue dbcTime = out.newList("dbcTime");
        ListValue httpcCount = out.newList("httpcCount");
        ListValue httpcTime = out.newList("httpcTime");
        ListValue threadId = out.newList("threadId");
        ListValue act_sql = out.newList("act_sql");
        ListValue act_httpc = out.newList("act_httpc");
        ListValue act_elapsed = out.newList("act_elapsed");
        ListValue act_target = out.newList("act_target");
        ListValue act_port = out.newList("act_port");
        ListValue act_status = out.newList("act_status");
        ListValue act_yellow_time = out.newList("act_yellow_time");
        ListValue act_red_time = out.newList("act_red_time");
        ListValue http_query = out.newList("http_query");
        ListValue appCtx = out.newList("appCtx");
        long currentTime = DateUtil.currentTime();
        if (maxcount <= 0) {
            maxcount = Integer.MAX_VALUE;
        }
        Enumeration<TraceContext> en = null;
        if (maxcount > TraceContextManager.size()) {
            LongKeyLinkedMap<TraceContext> m = TraceContextManager.getContextList();
            m.sortOut(new Comparator<LongKeyLinkedMap.LongKeyLinkedEntry<TraceContext>>(){

                @Override
                public int compare(LongKeyLinkedMap.LongKeyLinkedEntry<TraceContext> o1, LongKeyLinkedMap.LongKeyLinkedEntry<TraceContext> o2) {
                    int x = CompareUtil.compareTo(o2.getValue().currentElapsed, o1.getValue().currentElapsed);
                    if (x != 0) {
                        return x;
                    }
                    return CompareUtil.compareTo(o1.getValue().txid, o2.getValue().txid);
                }
            });
            en = m.values();
        } else {
            en = TraceContextManager.getContextEnumeration();
        }
        boolean hasAppCtx = StringUtil.isNotEmpty(appctx);
        while (en.hasMoreElements()) {
            int respTime;
            TraceContext ctx = en.nextElement();
            if (ctx == null || (respTime = ctx.getElapsedTime()) < mintime || hasAppCtx && !appctx.equals(ctx.appctx) || !ctx.addActiveTxListEnabled) continue;
            time.add(currentTime);
            tx_hash.add(ctx.service_hash);
            if (ActiveTx.conf.actx_origin_url_enabled && ctx.origin_url != null) {
                tx_name.add(ctx.origin_url);
            } else {
                tx_name.add(ctx.service_name);
            }
            txid.add(ctx.txid);
            profile.add(ctx.txid);
            ip.add(ctx.remoteIp);
            domain.add(ctx.http_host_hash);
            userid.add(ctx.wclientId);
            wclientId.add(ctx.wclientId);
            elapsed.add(respTime);
            if (ctx.start_cpu > 0L) {
                cputime.add((int)(SysJMX.getThreadCpuTime(ctx.thread.getId()) - ctx.start_cpu));
            } else if (ctx.start_cpu2 == 0L) {
                ctx.start_cpu2 = SysJMX.getThreadCpuTime(ctx.thread.getId());
                cputime.add(0L);
            } else {
                cputime.add((int)(SysJMX.getThreadCpuTime(ctx.thread.getId()) - ctx.start_cpu2));
            }
            if (ctx.start_malloc > 0L) {
                malloc.add(SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc);
            } else if (ctx.start_malloc2 == 0L) {
                ctx.start_malloc2 = SysJMX.getThreadAllocBytes(ctx.thread.getId());
                malloc.add(0L);
            } else {
                malloc.add(SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc2);
            }
            sqlCount.add(ctx.sql_count);
            sqlTime.add(ctx.sql_time);
            fetchCount.add(ctx.rs_count);
            fetchTime.add(ctx.rs_time);
            dbcTime.add(ctx.dbc_time);
            httpcCount.add(ctx.httpc_count);
            httpcTime.add(ctx.httpc_time);
            threadId.add(ctx.thread == null ? 0L : ctx.thread.getId());
            act_status.add(ctx.getActiveStatus());
            SqlStepX sql = ctx.sql;
            if (sql != null) {
                act_sql.add(sql.hash);
                act_httpc.add(0L);
                act_elapsed.add(respTime - sql.start_time);
                act_target.add(sql.dbc);
                act_port.add(0L);
            } else {
                act_sql.add(0L);
                act_httpc.add(ctx.active_httpc_hash);
                act_elapsed.add(ctx.active_httpc_hash == 0 ? 0L : (long)(respTime - ctx.httpc_stime));
                act_target.add(ctx.httpc_host_hash);
                act_port.add(ctx.httpc_port);
            }
            act_yellow_time.add(ctx.trace_active_transaction_yellow_time);
            act_red_time.add(ctx.trace_active_transaction_red_time);
            if (ActiveTx.conf.active_http_query_enabled) {
                http_query.add(StringUtil.limiting(ctx.http_query, ActiveTx.conf.http_query_max_length));
            }
            if (StringUtil.isNotEmpty(ctx.appctx)) {
                appCtx.add(ctx.appctx);
            }
            if (time.size() < maxcount) continue;
            break;
        }
        return out;
    }

    public static MapValue getActiveTxDetail(long txid) {
        MapValue out = new MapValue();
        TraceContext ctx = TraceContextManager.getContext(txid);
        if (ctx != null) {
            ActiveTx.ctxToMap(out, ctx);
        }
        return out;
    }

    static MapValue ctxToMap(MapValue out, TraceContext ctx) {
        int tm;
        out.put("time", DateUtil.now());
        out.put("tx_hash", ctx.service_hash);
        if (ActiveTx.conf.actx_origin_url_enabled && ctx.origin_url != null) {
            out.put("tx_name", ctx.origin_url);
        } else {
            out.put("tx_name", ctx.service_name);
        }
        out.put("profile", ctx.txid);
        out.put("txid", ctx.txid);
        if (ctx.remoteAddrIPv6) {
            out.put("ip", ctx.remoteAddr);
        } else {
            out.put("ip", ctx.remoteIp);
        }
        out.put("userid", ctx.wclientId);
        out.put("wclientId", ctx.wclientId);
        out.put("elapsed", ctx.getElapsedTime());
        if (ctx.start_cpu > 0L) {
            out.put("cputime", (int)(SysJMX.getThreadCpuTime(ctx.thread.getId()) - ctx.start_cpu));
        } else {
            out.put("cputime_thread", SysJMX.getThreadCpuTime(ctx.thread.getId()));
        }
        if (ctx.start_malloc > 0L) {
            out.put("malloc", SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc);
        } else {
            out.put("malloc_thread", SysJMX.getThreadAllocBytes(ctx.thread.getId()));
        }
        out.put("sqlCount", ctx.sql_count);
        out.put("sqlTime", ctx.sql_time);
        out.put("fetchCount", ctx.rs_count);
        out.put("fetchTime", ctx.rs_time);
        out.put("dbcTime", ctx.dbc_time);
        out.put("httpcCount", ctx.httpc_count);
        out.put("httpcTime", ctx.httpc_time);
        if (ctx.thread != null) {
            out.put("threadId", ctx.thread.getId());
            out.put("threadStateName", ctx.thread.getState().name());
            out.put("threadStat", ThreadStateEnum.getState(ctx.thread));
        }
        if (ctx.http_host != null) {
            out.put("httpHost", ctx.http_host);
        }
        if (ctx.http_content_type != null) {
            out.put("httpContentType", ctx.http_content_type);
        }
        if (ctx.http_url != null) {
            out.put("httpURL", ctx.http_url.toString());
        }
        out.put("act_status", ctx.getActiveStatus());
        SqlStepX sql = ctx.sql;
        if (sql != null) {
            if (sql.sid != 0) {
                String dbtype = ctx.sid == null ? "none" : DBType.getString(ctx.sid.dbtype);
                out.put("dbtype", dbtype);
                out.put("sid", sql.sid);
            }
            if (sql.serial != 0) {
                out.put("inst", sql.inst);
                out.put("serial", sql.serial);
            }
            out.put("act_dbc", sql.dbc);
            out.put("act_sql", sql.hash);
            if (sql.p1 != null) {
                out.put("act_sql_p1", new BlobValue(sql.p1));
            }
            if (sql.p2 != null) {
                out.put("act_sql_p2", new BlobValue(sql.p2));
            }
            out.put("act_elapsed", (tm = ctx.getElapsedTime() - sql.start_time) < 0 ? 0 : tm);
            out.put("act_sql_pcrc", ParamSecurity.keyHash);
        }
        if (ctx.active_httpc_hash != 0) {
            out.put("act_httpc", ctx.active_httpc_hash);
            out.put("act_httpc_host", ctx.httpc_host);
            out.put("act_httpc_port", ctx.httpc_port);
            tm = ctx.getElapsedTime() - ctx.httpc_stime;
            out.put("act_elapsed", tm < 0 ? 0 : tm);
        }
        out.put("method", ctx.http_method);
        if (ctx.mcaller_pcode != 0L) {
            out.put("mcaller_pcode", ctx.mcaller_pcode);
            out.put("mcaller_oid", ctx.mcaller_oid);
        }
        if (ctx.mtid != 0L) {
            out.put("mtid", ctx.mtid);
            out.put("mdepth", ctx.mdepth);
            out.put("mcaller", ctx.mcaller_txid);
            out.put("mcaller_step", ctx.mcaller_stepId);
        }
        out.put("act_yellow_time", ctx.trace_active_transaction_yellow_time);
        out.put("act_red_time", ctx.trace_active_transaction_red_time);
        StackTraceElement[] se = ctx.thread.getStackTrace();
        if (se != null && se.length > 1) {
            ListValue stack = new ListValue();
            for (int i = 0; i < se.length; ++i) {
                stack.add(se[i].toString());
            }
            out.put("callstack", stack);
        }
        out.put("http_query", ctx.http_query);
        if (ctx.appctx != null) {
            out.put("appCtx", ctx.appctx);
        }
        return out;
    }

    public static Value getCallStackOnly(long txid) {
        StackTraceElement[] se;
        TraceContext ctx = TraceContextManager.getContext(txid);
        if (ctx != null && ctx.txid == txid && ctx.thread != null && (se = ctx.thread.getStackTrace()) != null && se.length > 1) {
            ListValue stack = new ListValue();
            for (int i = 0; i < se.length; ++i) {
                stack.add(se[i].toString());
            }
            return stack;
        }
        return null;
    }
}

