/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfDBC;
import whatap.agent.control.ActiveTx;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.SID;
import whatap.lang.slog.SLog;
import whatap.lang.value.MapValue;

public class ActiveDBTxForSID {
    static Configure conf = Configure.getInstance();

    public static MapValue getActiveTxList(int dbtype, int sid, int serial, int inst) {
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        while (en.hasMoreElements()) {
            TraceContext ctx = en.nextElement();
            if (ctx == null || !ActiveDBTxForSID.checkDBSid(ctx, dbtype, sid, serial, inst)) continue;
            if (ConfDBC.debug_dbc_sid_enabled) {
                SLog slog = SLog.n("debug", "found actx").a("dbtype", dbtype).a("sid", sid).a("serial", serial).a("inst", inst);
                Logger.println(slog.yellow());
            }
            return ActiveTx.ctxToMap(new MapValue(), ctx);
        }
        if (ConfDBC.debug_dbc_sid_enabled) {
            SLog slog = SLog.n("debug", "fail to find actx").a("dbtype", dbtype).a("sid", sid).a("serial", serial).a("inst", inst);
            Logger.println(slog.red());
        }
        return null;
    }

    private static boolean checkDBSid(TraceContext ctx, int dbtype, int sid, int serial, int inst) {
        if (ctx.sql == null) {
            return false;
        }
        SID o = ctx.sid;
        if (o == null) {
            return false;
        }
        if (o.sid != sid || o.serial != serial || o.inst != inst) {
            return false;
        }
        if (dbtype == 0) {
            return true;
        }
        return o.dbtype == dbtype;
    }
}

