/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import whatap.agent.Configure;
import whatap.util.HashUtil;
import whatap.util.IntSet;
import whatap.util.StringLinkedSet;
import whatap.util.StringSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfTrace {
    public static boolean trace_zip_enabled = true;
    public static int trace_zip_queue_size = 1000;
    public static int trace_zip_max_wait_time = 1000;
    public static int trace_zip_max_wait2_time = 5000;
    public static int trace_zip_max_buffer_size = 0x100000;
    public static int trace_zip_min_size = 100;
    public static boolean debug_trace_zip_enabled = false;
    public static int debug_trace_zip_interval = 5000;
    public static int trace_txsplit_queue_size = 1000;
    public static boolean trace_http_header_enabled;
    private static final String DEFAULT_IGNORE_HEADER = "Cookie,cookie,accept,user-agent,referer";
    public static StringSet trace_http_header_ignore_keys;
    public static boolean trace_http_header_hash_enabled;
    public static String trace_http_header_url_prefix;
    public static boolean trace_http_parameter_enabled;
    public static String[] trace_http_parameter_keys;
    public static String trace_http_parameter_url_prefix;
    public static boolean trace_connection_open_enabled;
    public static int trace_step_normal_count;
    public static int trace_step_heavy_count;
    public static int trace_step_max_count;
    public static int trace_step_heavy_time;
    public static int trace_batch_main_step_max_count;
    public static final int DEFAULT_PROFILE_BASETIME = 500;
    public static int trace_basetime;
    public static boolean auto_trace_basetime;
    public static boolean trace_sql_param_enabled;
    public static boolean trace_batch_host_sql_param_enabled;
    public static boolean trace_sql_param_javatime_enabled;
    public static boolean trace_sql_resource_enabled;
    public static boolean trace_method_resource_enabled;
    public static boolean trace_httpc_resource_enabled;
    public static boolean _trace_prepare_sql;
    public static boolean trace_dbc_close;
    public static int _sql_param_dump_mode;
    public static boolean circular_trace_enabled;
    public static boolean large_trace_enabled;
    public static boolean split_trace_enabled;
    public static int _trace_collecting_mode;
    public static int trace_error_jdbc_fetch_max;
    public static int trace_error_sql_time_max;
    public static int trace_error_httpc_time_max;
    public static int trace_error_tx_time_max;
    public static boolean trace_error_step_enabled;
    public static int _trace_position_sql_hash;
    public static int _trace_position_httpc_hash;
    public static int _trace_position_method_hash;
    public static String[] trace_position_sql;
    public static String[] trace_position_httpc;
    public static String[] trace_position_method;
    public static int trace_position_depth;
    public static boolean trace_update_count;
    public static int trace_sql_param_length;
    public static String trace_sql_param_encoding;
    public static boolean trace_origin_url_enabled;
    public static boolean trace_origin_httpc_enabled;
    public static boolean trace_concern_error_enabled;
    public static boolean trace_custom_leak_enabled;
    public static boolean trace_filebody_enabled;
    public static String trace_filebody_postfix;
    public static int trace_filebody_length;
    public static boolean trace_file_length_enabled;
    public static boolean trace_from_stack_enabled;
    public static boolean custid_v1_enabled;
    public static boolean trace_sql_rs_enabled;
    public static String httpc_driver_name;
    public static boolean trace_sampling_enabled;
    public static int trace_sampling_tps;
    public static boolean trace_send_enabled;
    public static boolean debug_trace_sampling;
    public static boolean _has_ignore_sql;
    public static IntSet ignore_sql_hash_set;
    public static boolean trace_remote_ip6_enabled;
    public static List<String[]> trace_http_param_to_field;
    public static boolean trace_javax_servlet_enabled;
    public static boolean trace_sql_errorcode_enabled;
    public static boolean trace_sql_exception_enabled;
    public static boolean trace_exception_overwrite_enabled;
    public static boolean trace_exception_handler_overwrite_enabled;
    public static boolean trace_jakarta_servlet_enabled;
    public static boolean trace_exception_stack;
    public static boolean trace_exception_stack_overwrite_enabled;
    public static int trace_exception_depth;
    public static int trace_exception_title_len;
    public static boolean trace_method_error_stack;
    public static boolean trace_component_error_stack;
    public static int trace_method_error_depth;
    public static boolean trace_sql_error_stack;
    public static int trace_sql_error_depth;
    public static boolean trace_endtx_error_stack;
    public static int trace_endtx_error_depth;
    public static boolean trace_httpc_error_stack;
    public static int trace_httpc_error_depth;
    public static boolean trace_socket_error_stack;
    public static int trace_socket_error_depth;
    public static boolean trace_create_exception_enabled;
    public static boolean trace_create_exception_stack;
    public static int trace_create_exception_depth;
    public static IntSet ignore_sql_error_code_set;
    public static boolean debug_sql_nested;
    public static boolean trace_thread_start_enabled;
    public static boolean trace_thread_id_enabled;
    public static boolean trace_thread_name_enabled;
    public static boolean trace_cap_return_user_enabled;
    public static char url_cut_ch1;
    public static char url_cut_ch2;
    public static boolean trace_tx_name_with_method_enabled;
    public static String trace_tx_name_with_method_delimiter;
    public static boolean trace_newname_safe_enabled;
    public static boolean trace_pii_check_enabled;
    public static int trace_reactor_count;
    public static boolean txtext_txname_enabled;
    public static boolean txtext_error_enabled;
    public static int txtext_error_length;
    public static int trace_position_count;
    public static boolean trace_spring_scheduled_enabled;
    public static boolean trace_spring_scheduled_activetx_list_enabled;
    public static boolean trace_spring_scheduled_activetx_counter_enabled;
    public static boolean trace_spring_scheduled_counter_enabled;
    public static boolean trace_spring_async_annotation_enabled;
    public static boolean trace_spring_async_annotation_mtrace_enabled;
    public static boolean _has_changed_spring_async_annotation_name_prefix;
    public static String _spring_async_annotation_name_prefix;
    public static boolean trace_spring_async_annotation_activetx_list_enabled;
    public static boolean trace_spring_async_annotation_activetx_counter_enabled;
    public static boolean trace_spring_async_annotation_counter_enabled;
    public static String trace_spring_async_annotation_name_prefix;
    public static String trace_kafka_name_producer;
    public static String trace_kafka_name_consumer;
    public static boolean trace_point_step_message_enabled;
    public static boolean trace_service_background_enabled;
    public static boolean trace_service_background_error_only_enabled;

    public static synchronized void apply(Configure conf) {
        trace_zip_enabled = ConfTrace.getBoolean(conf, "profile_zip_enabled", true);
        trace_zip_queue_size = ConfTrace.getInt(conf, "profile_zip_queue_size", 1000);
        trace_zip_max_wait_time = ConfTrace.getInt(conf, "profile_zip_max_wait_time", 1000);
        trace_zip_max_wait2_time = ConfTrace.getInt(conf, "profile_zip_max_wait2_time", 5000);
        trace_zip_max_buffer_size = ConfTrace.getInt(conf, "profile_zip_max_buffer_size", 0x100000);
        trace_zip_min_size = ConfTrace.getInt(conf, "profile_zip_min_size", 100);
        debug_trace_zip_enabled = ConfTrace.getBoolean(conf, "debug_profile_zip_enabled", false);
        debug_trace_zip_interval = ConfTrace.getInt(conf, "debug_profile_zip_interval", 5000);
        trace_txsplit_queue_size = ConfTrace.getInt(conf, "trace_txsplit_queue_size", 1000);
        trace_http_header_enabled = ConfTrace.getBoolean(conf, "profile_http_header_enabled", false);
        trace_http_header_ignore_keys = new StringSet(StringUtil.tokenizer(ConfTrace.getValue(conf, "profile_http_header_ignore_keys", DEFAULT_IGNORE_HEADER), ","));
        trace_http_header_hash_enabled = ConfTrace.getBoolean(conf, "profile_http_header_hash_enabled", false);
        trace_http_parameter_enabled = ConfTrace.getBoolean(conf, "profile_http_parameter_enabled", false);
        trace_http_parameter_keys = StringUtil.tokenizer(ConfTrace.getValue(conf, "profile_http_parameter_keys"), ",");
        trace_http_parameter_url_prefix = ConfTrace.getValue(conf, "profile_http_parameter_url_prefix", "/");
        trace_http_header_url_prefix = ConfTrace.getValue(conf, "profile_http_header_url_prefix", "/");
        trace_connection_open_enabled = ConfTrace.getBoolean(conf, "profile_connection_open_enabled", true);
        trace_sql_param_enabled = ConfTrace.getBoolean(conf, "profile_sql_param_enabled", false);
        trace_batch_host_sql_param_enabled = ConfTrace.getBoolean(conf, "trace_batch_host_sql_param_enabled", false);
        trace_sql_param_javatime_enabled = ConfTrace.getBoolean(conf, "trace_sql_param_javatime_enabled", false);
        trace_sql_resource_enabled = ConfTrace.getBoolean(conf, "profile_sql_resource_enabled", false);
        trace_method_resource_enabled = ConfTrace.getBoolean(conf, "profile_method_resource_enabled", false);
        trace_httpc_resource_enabled = ConfTrace.getBoolean(conf, "profile_httpc_resource_enabled", false);
        trace_step_normal_count = ConfTrace.getInt(conf, "profile_step_normal_count", 1000);
        trace_step_heavy_count = ConfTrace.getInt(conf, "profile_step_heavy_count", 1020);
        trace_step_max_count = ConfTrace.getInt(conf, "profile_step_max_count", 1024);
        trace_step_heavy_time = ConfTrace.getInt(conf, "profile_step_heavy_time", 100);
        trace_batch_main_step_max_count = ConfTrace.getInt(conf, "trace_batch_main_step_max_count", 2000);
        if (trace_step_heavy_count > trace_step_max_count) {
            trace_step_heavy_count = trace_step_max_count;
        }
        if (trace_step_normal_count > trace_step_heavy_count) {
            trace_step_normal_count = trace_step_heavy_count;
        }
        if ("auto".equalsIgnoreCase(ConfTrace.getValue(conf, "profile_basetime", "auto"))) {
            auto_trace_basetime = true;
        } else {
            auto_trace_basetime = ConfTrace.getBoolean(conf, "auto_profile_basetime", ConfTrace.hasNotKey(conf, "profile_basetime"));
            trace_basetime = ConfTrace.getInt(conf, "profile_basetime", 500);
        }
        trace_error_jdbc_fetch_max = ConfTrace.getIntMustUpZero(conf, "profile_error_jdbc_fetch_max", 10000);
        trace_error_sql_time_max = ConfTrace.getIntMustUpZero(conf, "profile_error_sql_time_max", 30000);
        trace_error_httpc_time_max = ConfTrace.getIntMustUpZero(conf, "profile_error_httpc_time_max", 10000);
        trace_error_tx_time_max = ConfTrace.getInt(conf, "profile_error_tx_time_max", 0);
        trace_error_step_enabled = ConfTrace.getBoolean(conf, "profile_error_step_enabled", false);
        _trace_prepare_sql = ConfTrace.getBoolean(conf, "_profile_prepare_sql", false);
        trace_dbc_close = ConfTrace.getBoolean(conf, "profile_dbc_close", false);
        try {
            trace_position_httpc = ConfTrace.getStringSet(conf, "profile_position_httpc", "", ",").getArray();
            _trace_position_httpc_hash = trace_position_httpc.length > 0 ? HashUtil.hash(ConfTrace.getValue(conf, "profile_position_httpc", "")) : 0;
            trace_position_sql = ConfTrace.getStringSet(conf, "profile_position_sql", "", ",").getArray();
            _trace_position_sql_hash = trace_position_sql.length > 0 ? HashUtil.hash(ConfTrace.getValue(conf, "profile_position_sql", "")) : 0;
            trace_position_method = ConfTrace.getStringSet(conf, "profile_position_method", "", ",").getArray();
            _trace_position_method_hash = trace_position_method.length > 0 ? HashUtil.hash(ConfTrace.getValue(conf, "profile_position_method", "")) : 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        trace_position_depth = ConfTrace.getInt(conf, "profile_position_depth", 100);
        trace_update_count = ConfTrace.getBoolean(conf, "profile_update_count", false);
        circular_trace_enabled = ConfTrace.getBoolean(conf, "circular_profile_enabled", false);
        large_trace_enabled = ConfTrace.getBoolean(conf, "large_profile_enabled", false);
        split_trace_enabled = ConfTrace.getBoolean(conf, "split_profile_enabled", false);
        _trace_collecting_mode = split_trace_enabled ? 4 : (large_trace_enabled ? 3 : (circular_trace_enabled ? 2 : 1));
        trace_sql_param_length = ConfTrace.getInt(conf, "profile_sql_param_length", 40);
        trace_sql_param_encoding = ConfTrace.getValue(conf, "profile_sql_param_encoding", "");
        boolean b1 = StringUtil.isNotEmpty(trace_sql_param_encoding);
        boolean b2 = ConfTrace.getBoolean(conf, "profile_sql_param_dump_enabled", false);
        _sql_param_dump_mode = b1 && b2 ? 4 : (b1 ? 3 : (b2 ? 2 : 1));
        trace_custom_leak_enabled = ConfTrace.getBoolean(conf, "profile_custom_leak_enabled", true);
        trace_from_stack_enabled = ConfTrace.getBoolean(conf, "profile_from_stack_enabled", false);
        trace_origin_url_enabled = ConfTrace.getBoolean(conf, "profile_origin_url_enabled", true);
        trace_concern_error_enabled = ConfTrace.getBoolean(conf, "profile_concern_error_enabled", true);
        trace_filebody_enabled = ConfTrace.getBoolean(conf, "profile_filebody_enabled", false);
        trace_filebody_postfix = ConfTrace.getValue(conf, "profile_filebody_postfix", ".json");
        trace_filebody_length = ConfTrace.getInt(conf, "profile_filebody_length", 100);
        trace_file_length_enabled = ConfTrace.getBoolean(conf, "trace_file_length_enabled", false);
        trace_origin_httpc_enabled = ConfTrace.getBoolean(conf, "profile_origin_httpc_enabled", true);
        custid_v1_enabled = conf.getBoolean("custid_v1_enabled", false);
        trace_sql_rs_enabled = conf.getBoolean("trace_sql_rs_enabled", true);
        httpc_driver_name = conf.getValue("httpc_driver_name");
        trace_sampling_enabled = conf.getBoolean("trace_sampling_enabled", false);
        trace_sampling_tps = conf.getInt("trace_sampling_tps", 10000);
        trace_send_enabled = conf.getBoolean("trace_send_enabled", true);
        debug_trace_sampling = conf.getBoolean("debug_trace_sampling", false);
        ignore_sql_hash_set = conf.getIntSet("ignore_sql_hash_set", "", ",");
        _has_ignore_sql = ignore_sql_hash_set.size() > 0;
        trace_remote_ip6_enabled = conf.getBoolean("trace_remote_ip6_enabled", false);
        trace_http_param_to_field = ConfTrace.getTraceExtraByParam(conf, "trace_http_param_to_field", trace_http_param_to_field);
        trace_javax_servlet_enabled = conf.transaction_enabled && conf.getBoolean("trace_javax_servlet_enabled", true);
        trace_sql_errorcode_enabled = conf.getBoolean("trace_sql_errorcode_enabled", true);
        trace_sql_exception_enabled = conf.getBoolean("trace_sql_exception_enabled", true);
        trace_exception_overwrite_enabled = conf.getBoolean("trace_exception_overwrite_enabled", true);
        trace_exception_handler_overwrite_enabled = conf.getBoolean("trace_exception_handler_overwrite_enabled", true);
        trace_jakarta_servlet_enabled = conf.transaction_enabled && conf.getBoolean("trace_jakarta_servlet_enabled", true);
        trace_exception_stack = ConfTrace.getBoolean(conf, "profile_exception_stack", false);
        trace_exception_stack_overwrite_enabled = conf.getBoolean("trace_exception_stack_overwrite_enabled", false);
        trace_exception_depth = conf.getInt("trace_exception_depth", 50);
        trace_sql_error_stack = conf.getBoolean("trace_sql_error_stack", trace_exception_stack);
        trace_sql_error_depth = conf.getInt("trace_sql_error_depth", trace_exception_depth);
        trace_httpc_error_stack = conf.getBoolean("trace_httpc_error_stack", trace_exception_stack);
        trace_httpc_error_depth = ConfTrace.getInt(conf, "trace_httpc_error_depth", trace_exception_depth);
        trace_socket_error_stack = conf.getBoolean("trace_socket_error_stack", trace_exception_stack);
        trace_socket_error_depth = ConfTrace.getInt(conf, "trace_socket_error_depth", trace_exception_depth);
        trace_method_error_stack = conf.getBoolean("trace_method_error_stack", trace_exception_stack);
        trace_component_error_stack = conf.getBoolean("trace_component_error_stack", trace_method_error_stack);
        trace_method_error_depth = conf.getInt("trace_method_error_depth", trace_exception_depth);
        trace_endtx_error_stack = conf.getBoolean("trace_endtx_error_stack", trace_exception_stack);
        trace_endtx_error_depth = conf.getInt("trace_endtx_error_depth", trace_exception_depth);
        trace_create_exception_enabled = conf.getBoolean("trace_create_exception_enabled", true);
        trace_create_exception_stack = conf.getBoolean("trace_create_exception_stack", true);
        trace_create_exception_depth = conf.getInt("trace_create_exception_depth", trace_exception_depth);
        trace_exception_title_len = conf.getInt("trace_exception_title_len", 128);
        ignore_sql_error_code_set = conf.getIntSet("ignore_sql_error_code_set", "", ",");
        debug_sql_nested = conf.getBoolean("debug_sql_nasted", false);
        trace_thread_start_enabled = conf.getBoolean("trace_thread_start_enabled", false);
        trace_thread_id_enabled = conf.getBoolean("trace_thread_id_enabled", false);
        trace_thread_name_enabled = conf.getBoolean("trace_thread_name_enabled", false);
        trace_cap_return_user_enabled = conf.getBoolean("trace_cap_return_user_enabled", false);
        url_cut_ch1 = conf.getChar("url_cut_ch1", ';');
        url_cut_ch2 = conf.getChar("url_cut_ch2", '\u0000');
        trace_tx_name_with_method_enabled = conf.getBoolean("trace_tx_name_with_method_enabled", false);
        trace_tx_name_with_method_delimiter = conf.getValue("trace_tx_name_with_method_delimiter", "+");
        trace_tx_name_with_method_delimiter = StringUtil.isEmpty(trace_tx_name_with_method_delimiter) ? "+" : StringUtil.truncate(trace_tx_name_with_method_delimiter, 2);
        trace_newname_safe_enabled = conf.getBoolean("trace_newname_safe_enabled", false);
        trace_pii_check_enabled = conf.getBoolean("trace_pii_check_enabled", false);
        trace_reactor_count = conf.getInt("trace_reactor_count", 100);
        txtext_txname_enabled = conf.getBoolean("txtext_txname_enabled", true);
        txtext_error_enabled = conf.getBoolean("txtext_error_enabled", true);
        txtext_error_length = conf.getInt("txtext_error_length", 128);
        if (txtext_error_length < 1) {
            txtext_error_enabled = false;
        }
        trace_position_count = conf.getInt("trace_position_count", 1000000);
        trace_spring_scheduled_enabled = conf.getBoolean("trace_spring_scheduled_enabled", false);
        trace_spring_scheduled_activetx_list_enabled = conf.getBoolean("trace_spring_scheduled_activetx_list_enabled", true);
        trace_spring_scheduled_activetx_counter_enabled = conf.getBoolean("trace_spring_scheduled_activetx_counter_enabled", true);
        trace_spring_scheduled_counter_enabled = conf.getBoolean("trace_spring_scheduled_counter_enabled", true);
        trace_spring_async_annotation_enabled = conf.getBoolean("trace_spring_async_annotation_enabled", true);
        trace_spring_async_annotation_mtrace_enabled = conf.getBoolean("trace_spring_async_annotation_mtrace_enabled", true);
        trace_spring_async_annotation_activetx_list_enabled = conf.getBoolean("trace_spring_async_annotation_activetx_list_enabled", true);
        trace_spring_async_annotation_activetx_counter_enabled = conf.getBoolean("trace_spring_async_annotation_activetx_counter_enabled", true);
        trace_spring_async_annotation_name_prefix = conf.getValue("trace_spring_async_annotation_name_prefix", "Async@");
        _has_changed_spring_async_annotation_name_prefix = _spring_async_annotation_name_prefix != null && !_spring_async_annotation_name_prefix.equals(trace_spring_async_annotation_name_prefix);
        _spring_async_annotation_name_prefix = trace_spring_async_annotation_name_prefix;
        trace_kafka_name_producer = conf.getValue("trace_kafka_name_producer", "Kafka");
        trace_kafka_name_producer = trace_kafka_name_producer.length() > 20 ? trace_kafka_name_producer.substring(0, 20) : trace_kafka_name_producer;
        trace_kafka_name_consumer = conf.getValue("trace_kafka_name_consumer", "kafka");
        trace_kafka_name_consumer = trace_kafka_name_consumer.length() > 20 ? trace_kafka_name_consumer.substring(0, 20) : trace_kafka_name_consumer;
        trace_point_step_message_enabled = conf.getBoolean("trace_point_step_message_enabled", false);
        trace_service_background_enabled = conf.getBoolean("trace_service_background_enabled", true);
        trace_service_background_error_only_enabled = conf.getBoolean("trace_service_background_error_only_enabled", false);
    }

    protected static List<String[]> getTraceExtraByParam(Configure conf, String key, List<String[]> org) {
        String v = conf.getValue(key);
        if (v != null && v.length() > 0) {
            StringTokenizer nizer = new StringTokenizer(v, ",");
            ArrayList<String[]> arr = new ArrayList<String[]>();
            while (nizer.hasMoreTokens()) {
                String s = StringUtil.trimEmpty(nizer.nextToken());
                String[] s2 = StringUtil.tokenizer(s, ":");
                if (s2 == null || s2.length != 2) continue;
                arr.add(s2);
            }
            return arr;
        }
        if (org == null || org.size() > 0) {
            return new ArrayList<String[]>(1);
        }
        return org;
    }

    private static String getValue(Configure conf, String profileKey) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getValue(traceKey, conf.getValue(profileKey));
    }

    private static StringLinkedSet getStringSet(Configure conf, String profileKey, String defaultValue, String deli) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getStringSet(traceKey, conf.getValue(profileKey, defaultValue), deli);
    }

    private static int getIntMustUpZero(Configure conf, String profileKey, int i) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getIntMustUpZero(traceKey, conf.getIntMustUpZero(profileKey, i));
    }

    private static boolean hasNotKey(Configure conf, String profileKey) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.hasNotKey(traceKey) && conf.hasNotKey(profileKey);
    }

    private static String getValue(Configure conf, String profileKey, String def) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getValue(traceKey, conf.getValue(profileKey, def));
    }

    private static int getInt(Configure conf, String profileKey, int def) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getInt(traceKey, conf.getInt(profileKey, def));
    }

    private static boolean getBoolean(Configure conf, String profileKey, boolean def) {
        String traceKey = profileKey.replace("profile", "trace");
        return conf.getBoolean(traceKey, conf.getBoolean(profileKey, def));
    }

    static {
        trace_http_header_ignore_keys = new StringSet();
        trace_http_header_url_prefix = "/";
        trace_http_parameter_keys = null;
        trace_http_parameter_url_prefix = "/";
        trace_connection_open_enabled = true;
        trace_step_normal_count = 1000;
        trace_step_heavy_count = 1020;
        trace_step_max_count = 1024;
        trace_step_heavy_time = 100;
        trace_batch_main_step_max_count = 2000;
        trace_basetime = 500;
        auto_trace_basetime = true;
        trace_sql_param_enabled = false;
        trace_batch_host_sql_param_enabled = false;
        trace_sql_param_javatime_enabled = false;
        trace_sql_resource_enabled = false;
        trace_method_resource_enabled = false;
        trace_httpc_resource_enabled = false;
        _trace_prepare_sql = false;
        trace_dbc_close = false;
        _sql_param_dump_mode = 0;
        circular_trace_enabled = false;
        large_trace_enabled = false;
        split_trace_enabled = false;
        _trace_collecting_mode = 1;
        trace_error_jdbc_fetch_max = 10000;
        trace_error_sql_time_max = 30000;
        trace_error_httpc_time_max = 10000;
        trace_error_tx_time_max = 0;
        trace_error_step_enabled = false;
        _trace_position_sql_hash = 0;
        _trace_position_httpc_hash = 0;
        _trace_position_method_hash = 0;
        trace_position_sql = new String[0];
        trace_position_httpc = new String[0];
        trace_position_method = new String[0];
        trace_position_depth = 100;
        trace_update_count = false;
        trace_sql_param_length = 40;
        trace_sql_param_encoding = "";
        trace_origin_url_enabled = true;
        trace_origin_httpc_enabled = true;
        trace_concern_error_enabled = true;
        trace_custom_leak_enabled = true;
        trace_filebody_enabled = false;
        trace_filebody_postfix = ".json";
        trace_filebody_length = 100;
        trace_file_length_enabled = false;
        trace_from_stack_enabled = false;
        custid_v1_enabled = false;
        trace_sql_rs_enabled = true;
        httpc_driver_name = null;
        trace_sampling_enabled = false;
        trace_sampling_tps = 10000;
        trace_send_enabled = true;
        debug_trace_sampling = false;
        _has_ignore_sql = false;
        ignore_sql_hash_set = new IntSet();
        trace_remote_ip6_enabled = false;
        trace_http_param_to_field = new ArrayList<String[]>(1);
        trace_javax_servlet_enabled = true;
        trace_sql_errorcode_enabled = true;
        trace_sql_exception_enabled = true;
        trace_exception_overwrite_enabled = true;
        trace_exception_handler_overwrite_enabled = true;
        trace_jakarta_servlet_enabled = true;
        trace_exception_stack = false;
        trace_exception_stack_overwrite_enabled = false;
        trace_exception_depth = 50;
        trace_exception_title_len = 128;
        trace_component_error_stack = trace_method_error_stack = trace_exception_stack;
        trace_method_error_depth = trace_exception_depth;
        trace_sql_error_stack = trace_exception_stack;
        trace_sql_error_depth = trace_exception_depth;
        trace_endtx_error_stack = trace_exception_stack;
        trace_endtx_error_depth = trace_exception_depth;
        trace_httpc_error_stack = trace_exception_stack;
        trace_httpc_error_depth = trace_exception_depth;
        trace_socket_error_stack = trace_exception_stack;
        trace_socket_error_depth = trace_exception_depth;
        trace_create_exception_enabled = true;
        trace_create_exception_stack = true;
        trace_create_exception_depth = trace_exception_depth;
        ignore_sql_error_code_set = new IntSet();
        debug_sql_nested = false;
        trace_thread_start_enabled = false;
        trace_thread_id_enabled = false;
        trace_thread_name_enabled = false;
        trace_cap_return_user_enabled = false;
        url_cut_ch1 = (char)59;
        url_cut_ch2 = '\u0000';
        trace_tx_name_with_method_enabled = false;
        trace_tx_name_with_method_delimiter = "+";
        trace_newname_safe_enabled = false;
        trace_pii_check_enabled = false;
        trace_reactor_count = 100;
        txtext_txname_enabled = true;
        txtext_error_enabled = true;
        txtext_error_length = 128;
        trace_position_count = 1000000;
        trace_spring_scheduled_enabled = false;
        trace_spring_scheduled_activetx_list_enabled = true;
        trace_spring_scheduled_activetx_counter_enabled = true;
        trace_spring_scheduled_counter_enabled = true;
        trace_spring_async_annotation_enabled = false;
        trace_spring_async_annotation_mtrace_enabled = true;
        _has_changed_spring_async_annotation_name_prefix = false;
        trace_spring_async_annotation_activetx_list_enabled = true;
        trace_spring_async_annotation_activetx_counter_enabled = true;
        trace_spring_async_annotation_counter_enabled = true;
        trace_spring_async_annotation_name_prefix = "Async@";
        trace_kafka_name_producer = "Kafka";
        trace_kafka_name_consumer = "kafka";
        trace_point_step_message_enabled = false;
        trace_service_background_enabled = true;
        trace_service_background_error_only_enabled = false;
    }
}

