/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import java.util.Enumeration;
import java.util.List;
import whatap.agent.api.weaving.SkipLoad;
import whatap.agent.api.weaving.SkipMethod;
import whatap.agent.api.weaving.Tracing;
import whatap.agent.api.weaving.Weaving;
import whatap.agent.asm.IASM;
import whatap.agent.asm.weaving.MethodNodeWrap;
import whatap.agent.asm.weaving.WeavePackage;
import whatap.agent.asm.weaving.WeavingHookSet;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.Method;
import whatap.org.objectweb.asm.tree.AnnotationNode;
import whatap.org.objectweb.asm.tree.ClassNode;
import whatap.org.objectweb.asm.tree.FieldNode;
import whatap.org.objectweb.asm.tree.MethodNode;
import whatap.util.LinkedMap;
import whatap.util.StringUtil;

public class ClassNodeX
extends ClassNode {
    private static final String WEAVING = Type.getType(Weaving.class).getDescriptor();
    private static final String SKIP_LOAD = Type.getType(SkipLoad.class).getDescriptor();
    private static final String TRACING = Type.getType(Tracing.class).getDescriptor();
    private static final String SKIP_METHOD = Type.getType(SkipMethod.class).getDescriptor();
    public WeavePackage parent;
    public String match = null;
    public String realClassName;
    public byte[] realBody;
    public String prefix;
    public boolean hasPrefix = false;
    public LinkedMap<Method, MethodNodeWrap> methodMap = new LinkedMap();
    public LinkedMap<String, FieldNode> fieldMap = new LinkedMap();

    public ClassNodeX() {
        super(IASM.API);
    }

    public void buildNormal() {
        for (FieldNode f : this.fields) {
            this.fieldMap.put(f.name, f);
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            MethodNode m = (MethodNode)this.methods.get(i);
            this.methodMap.put(new Method(m.name, m.desc), new MethodNodeWrap(i, m));
        }
        this.realClassName = this.name;
    }

    public void buildWeave() {
        this.buildNormal();
        if (this.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : this.visibleAnnotations) {
                if (annotationNode.desc.equals(WEAVING)) {
                    this.match = "class";
                    this.realClassName = this.name;
                    this.parse(annotationNode);
                    continue;
                }
                if (!annotationNode.desc.equals(SKIP_LOAD)) continue;
                this.match = "ignore";
                this.realClassName = this.name;
            }
        }
        Enumeration<MethodNodeWrap> en = this.methodMap.values();
        block1: while (en.hasMoreElements()) {
            MethodNodeWrap m = en.nextElement();
            List<AnnotationNode> annoList = m.method.visibleAnnotations;
            if (annoList == null) continue;
            for (AnnotationNode annotationNode : annoList) {
                if (annotationNode.desc.equals(TRACING)) {
                    String txmode = this.parseTrace(annotationNode);
                    if (txmode == null) {
                        WeavingHookSet.addProfile(this.name, m.method.name, m.method.desc);
                        continue block1;
                    }
                    if ("http".equals(txmode)) {
                        WeavingHookSet.addHttpTx(this.name, m.method.name, m.method.desc);
                        continue block1;
                    }
                    if ("service".equals(txmode)) {
                        WeavingHookSet.addServiceTx(this.name, m.method.name, m.method.desc);
                        continue block1;
                    }
                    WeavingHookSet.addProfile(this.name, m.method.name, m.method.desc);
                    continue block1;
                }
                if (!annotationNode.desc.equals(SKIP_METHOD)) continue;
                MethodNodeWrap.skip = true;
                continue block1;
            }
        }
    }

    private void parse(AnnotationNode annotationNode) {
        if (null != annotationNode.values) {
            for (int i = 0; i < annotationNode.values.size(); i += 2) {
                if ("match".equals(annotationNode.values.get(i))) {
                    this.match = StringUtil.toLower(String.valueOf(annotationNode.values.get(i + 1)));
                    continue;
                }
                if ("name".equals(annotationNode.values.get(i))) {
                    this.realClassName = String.valueOf(annotationNode.values.get(i + 1)).replace('.', '/');
                    continue;
                }
                if (!"prefix".equals(annotationNode.values.get(i))) continue;
                this.prefix = String.valueOf(annotationNode.values.get(i + 1)).replace('.', '/');
            }
        }
        this.hasPrefix = StringUtil.isNotEmpty(this.prefix);
    }

    private String parseTrace(AnnotationNode annotationNode) {
        if (null != annotationNode.values) {
            for (int i = 0; i < annotationNode.values.size(); i += 2) {
                if (!"tx".equals(annotationNode.values.get(i))) continue;
                return StringUtil.toLower(String.valueOf(annotationNode.values.get(i + 1)));
            }
        }
        return null;
    }
}

