/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.reactor;

import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class ServiceReactorMV
extends LocalVariablesSorter
implements Opcodes {
    static final String MONO = "Lreactor/core/publisher/Mono;";
    static final String FLUX = "Lreactor/core/publisher/Flux;";
    static final Type MONO_TYPE = Type.getType("Lreactor/core/publisher/Mono;");
    static final Type FLUX_TYPE = Type.getType("Lreactor/core/publisher/Flux;");
    private static final String TRACE_CLASS = "whatap/bci/reactor/ReactorTrace";
    private static final String METHOD_NAME = "startTx";
    private static final String MONO_SIGNATURE = "(Lreactor/core/publisher/Mono;Ljava/lang/String;)Lreactor/core/publisher/Mono;";
    private static final String FLUX_SIGNATURE = "(Lreactor/core/publisher/Flux;Ljava/lang/String;)Lreactor/core/publisher/Flux;";
    private int argMonoIdx = -1;
    private int argFluxIdx = -1;
    private boolean rtnFlux;
    private boolean rtnMono;
    private String classMethod;
    private boolean isReturnHooking;

    public ServiceReactorMV(int access, String desc, MethodVisitor mv, String classMethod, Type[] paramTypes) {
        super(IASM.API, access, desc, mv);
        this.classMethod = classMethod;
        int sidx = AsmUtil.isStatic(access) ? 0 : 1;
        Type[] argTypes = Type.getArgumentTypes(desc);
        for (int i = 0; argTypes != null && i < argTypes.length; ++i) {
            if (MONO_TYPE.equals(argTypes[i])) {
                this.argMonoIdx = sidx;
                break;
            }
            if (FLUX_TYPE.equals(argTypes[i])) {
                this.argFluxIdx = sidx;
                break;
            }
            sidx += argTypes[i].getSize();
        }
        if (this.argFluxIdx < 0 && this.argMonoIdx < 0) {
            this.rtnFlux = desc.endsWith(FLUX);
            this.rtnMono = desc.endsWith(MONO);
            this.isReturnHooking = this.rtnFlux || this.rtnMono;
        }
    }

    public void visitCode() {
        if (this.argMonoIdx >= 0) {
            this.mv.visitVarInsn(25, this.argMonoIdx);
            AsmUtil.PUSH(this.mv, this.classMethod);
            this.mv.visitMethodInsn(184, TRACE_CLASS, METHOD_NAME, MONO_SIGNATURE, false);
            this.mv.visitVarInsn(58, this.argMonoIdx);
            this.isReturnHooking = false;
        } else if (this.argFluxIdx >= 0) {
            this.mv.visitVarInsn(25, this.argFluxIdx);
            AsmUtil.PUSH(this.mv, this.classMethod);
            this.mv.visitMethodInsn(184, TRACE_CLASS, METHOD_NAME, FLUX_SIGNATURE, false);
            this.mv.visitVarInsn(58, this.argFluxIdx);
            this.isReturnHooking = false;
        }
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177 && this.isReturnHooking) {
            if (this.rtnMono) {
                AsmUtil.PUSH(this.mv, this.classMethod);
                this.mv.visitMethodInsn(184, TRACE_CLASS, METHOD_NAME, MONO_SIGNATURE, false);
            } else if (this.rtnFlux) {
                AsmUtil.PUSH(this.mv, this.classMethod);
                this.mv.visitMethodInsn(184, TRACE_CLASS, METHOD_NAME, FLUX_SIGNATURE, false);
            }
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

