/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.jdbc;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.asm.IASM;
import whatap.agent.asm.jdbc.JdbcAsm;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

public class CstmtSetMV
extends LocalVariablesSorter
implements Opcodes {
    private String owner;
    private String name;
    private Type[] args;
    private static Map<String, String> target = new HashMap<String, String>();
    private static final String TRACESQL;

    public static String getSetSignature(String name) {
        return target.get(name);
    }

    public CstmtSetMV(int access, String name, String desc, MethodVisitor mv, String owner) {
        super(IASM.API, access, desc, mv);
        this.owner = owner;
        this.args = Type.getArgumentTypes(desc);
        this.name = name;
    }

    public void visitCode() {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.owner, "_wsqlparam_", "Lwhatap/agent/trace/SqlParameter;");
        this.mv.visitVarInsn(21, 1);
        if (this.name.equals("setNull")) {
            AsmUtil.PUSH(this.mv, (String)null);
            this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ILjava/lang/String;)V", false);
        } else if (this.name.equals("registerOutParameter")) {
            AsmUtil.PUSH(this.mv, "[out]");
            this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ILjava/lang/String;)V", false);
        } else {
            Type tp = this.args[1];
            switch (tp.getSort()) {
                case 1: {
                    this.mv.visitVarInsn(21, 2);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;IZ)V", false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    this.mv.visitVarInsn(21, 2);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;II)V", false);
                    break;
                }
                case 7: {
                    this.mv.visitVarInsn(22, 2);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;IJ)V", false);
                    break;
                }
                case 6: {
                    this.mv.visitVarInsn(23, 2);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;IF)V", false);
                    break;
                }
                case 8: {
                    this.mv.visitVarInsn(24, 2);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ID)V", false);
                    break;
                }
                case 9: 
                case 10: {
                    this.mv.visitVarInsn(25, 2);
                    if (tp.equals(AsmUtil.stringType)) {
                        this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ILjava/lang/String;)V", false);
                        break;
                    }
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ILjava/lang/Object;)V", false);
                    break;
                }
                default: {
                    this.mv.visitVarInsn(25, 2);
                    AsmUtil.PUSH(this.mv, "unknown " + tp);
                    this.mv.visitMethodInsn(184, TRACESQL, "set", "(Lwhatap/agent/trace/SqlParameter;ILjava/lang/String;)V", false);
                }
            }
        }
        super.visitCode();
    }

    static {
        target.put("setNull", "(II");
        target.put("setByte", "(IB)V");
        target.put("setBoolean", "(IZ)V");
        target.put("setShort", "(IS)V");
        target.put("setInt", "(II)V");
        target.put("setFloat", "(IF)V");
        target.put("setLong", "(IJ)V");
        target.put("setDouble", "(ID)V");
        target.put("setBigDecimal", "(ILjava/math/BigDecimal;)V");
        target.put("setBlob", "(ILjava/sql/Blob;)V");
        target.put("setClob", "(ILjava/sql/Clob;)V");
        target.put("setObject", "(ILjava/lang/Object;");
        target.put("setString", "(ILjava/lang/String;)V");
        target.put("setDate", "(ILjava/sql/Date;)V");
        target.put("setTime", "(ILjava/sql/Time;)V");
        target.put("setTimestamp", "(ILjava/sql/Timestamp;)V");
        target.put("setURL", "(ILjava/net/URL;)V");
        target.put("registerOutParameter", "(I");
        TRACESQL = JdbcAsm.TRACE_SQL;
    }
}

