/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.MethodLogCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class MethodLogASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfHook.hook_mlog_patterns);
    private HashMap<String, HookingSet> supers = HookingSet.getHookingClassMethodSet(ConfHook.hook_mlog_supers);
    private HashMap<String, HookingSet> interfaces = HookingSet.getHookingClassMethodSet(ConfHook.hook_mlog_interfaces);

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new MethodLogCV(cv, mset, className);
        }
        HookingSet mset = this.supers.get(classDesc.superName);
        if (mset != null) {
            return new MethodLogCV(cv, mset, className);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (int i = 0; i < classDesc.interfaces.length; ++i) {
                mset = this.interfaces.get(classDesc.interfaces[i]);
                if (mset == null) continue;
                return new MethodLogCV(cv, mset, className);
            }
        }
        return cv;
    }
}

