/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.ResultSetCV;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCResultSetASM
extends IASM
implements Opcodes {
    public final HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_jdbc_rs_classes);

    public JDBCResultSetASM() {
        if (!ConfHook.hook_jdbc_rs_default_enabled) {
            return;
        }
        this.add(this.target, "org.mariadb.jdbc.MySQLResultSet");
        if (ConfHook.hook_oracle_rs_enabled) {
            this.add(this.target, "oracle.jdbc.driver.OracleResultSetImpl");
            this.add(this.target, "oracle.jdbc.driver.InsensitiveScrollableResultSet");
            this.add(this.target, "oracle.jdbc.driver.SensitiveScrollableResultSet");
        }
        this.add(this.target, "com.mysql.jdbc.ResultSetImpl");
        this.add(this.target, "com.mysql.cj.jdbc.result.ResultSetImpl");
        this.add(this.target, "org.postgresql.jdbc2.AbstractJdbc2ResultSet");
        this.add(this.target, "org.apache.derby.impl.jdbc.EmbedResultSet");
        this.add(this.target, "org.apache.derby.client.am.ResultSet");
        this.add(this.target, "bmt.jdbc.FakeResultSet");
        this.add(this.target, "jdbc.FakeResultSet");
        this.add(this.target, "net.sourceforge.jtds.jdbc.JtdsResultSet");
        this.add(this.target, "com.microsoft.sqlserver.jdbc.SQLServerResultSet");
        this.add(this.target, "com.tmax.tibero.jdbc.TbResultSet");
        this.add(this.target, "org.hsqldb.jdbc.JDBCResultSet");
        this.add(this.target, "cubrid.jdbc.driver.CUBRIDResultSet");
        this.add(this.target, "org.mariadb.jdbc.MariaDbResultSet");
        this.add(this.target, "org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet");
        this.add(this.target, "software.aws.rds.jdbc.mysql.shading.com.mysql.cj.jdbc.result.ResultSetImpl");
        this.add(this.target, "org.mariadb.jdbc.client.result.Result");
        this.add(this.target, "org.mariadb.jdbc.client.result.CompleteResult");
        this.add(this.target, "org.mariadb.jdbc.client.result.StreamingResult");
        this.add(this.target, "org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet");
        this.add(this.target, "org.postgresql.jdbc.PgResultSet");
        this.add(this.target, "com.edb.jdbc.PgResultSet");
        this.add(this.target, "com.ibm.as400.access.AS400JDBCResultSet");
        this.add(this.target, "com.informix.jdbc.IfxResultSet");
        this.add(this.target, "Altibase.jdbc.driver.AltibaseResultSet");
        this.add(this.target, "Altibase.jdbc.driver.ABResultSet");
        this.add(this.target, "Altibase5.jdbc.driver.ABResultSet");
        this.add(this.target, "com.tmax.tibero.jdbc.TbResultSet");
        this.add(this.target, "com.tmax.tibero.jdbc.driver.TbResultSetBase");
        this.add(this.target, "org.h2.jdbc.JdbcResultSet");
        this.add(this.target, "com.sybase.jdbc2.jdbc.SybResultSet");
        this.add(this.target, "com.sybase.jdbc4.jdbc.SybResultSet");
    }

    protected void add(HashSet<String> target, String className) {
        target.add(className.replace('.', '/'));
    }

    @Override
    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    @Override
    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("BCI", "jdbc-rs " + className);
        return new ResultSetCV(cv);
    }
}

