/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.PreparedStatementCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.Pair;

public class JDBCPreparedStatementASM
extends IASM
implements Opcodes {
    public static HashMap<String, String> sqlParam = new HashMap();
    public static HashSet<Pair<String, String>> ignoreInit;
    public final HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_jdbc_pstmt_classes);
    public static final HashSet<String> noField;

    public JDBCPreparedStatementASM() {
        noField.clear();
        noField.addAll(HookingSet.getHookingClassSet(ConfHook.hook_jdbc_pstmt_nofield_classes));
        if (!ConfHook.hook_jdbc_pstmt_default_enabled) {
            return;
        }
        this.target.add("org/mariadb/jdbc/AbstractMariaDbPrepareStatement");
        this.target.add("org/mariadb/jdbc/MySQLServerSidePreparedStatement");
        this.target.add("org/mariadb/jdbc/MySQLPreparedStatement");
        this.target.add("org/mariadb/jdbc/MariaDbClientPreparedStatement");
        this.target.add("org/mariadb/jdbc/MariaDbServerPreparedStatement");
        this.target.add("org/mariadb/jdbc/AbstractPrepareStatement");
        this.target.add("org/mariadb/jdbc/BasePrepareStatement");
        this.target.add("org/mariadb/jdbc/MariaDbPreparedStatementClient");
        this.target.add("org/mariadb/jdbc/MariaDbPreparedStatementServer");
        this.target.add("org/mariadb/jdbc/ClientSidePreparedStatement");
        this.target.add("org/mariadb/jdbc/BasePreparedStatement");
        this.target.add("org/mariadb/jdbc/ClientPreparedStatement");
        this.target.add("org/mariadb/jdbc/ServerPreparedStatement");
        this.target.add("com/mysql/jdbc/PreparedStatement");
        this.target.add("com/mysql/cj/jdbc/PreparedStatement");
        this.target.add("com/mysql/jdbc/ServerPreparedStatement");
        this.target.add("com/mysql/cj/jdbc/ServerPreparedStatement");
        this.target.add("com/mysql/cj/jdbc/ClientPreparedStatement");
        this.target.add("software/aws/rds/jdbc/mysql/shading/com/mysql/cj/jdbc/ClientPreparedStatement");
        this.target.add("software/aws/rds/jdbc/mysql/shading/com/mysql/cj/jdbc/ServerPreparedStatement");
        if (ConfHook.hook_oracle_pstmt_enabled) {
            this.target.add("oracle/jdbc/driver/OraclePreparedStatement");
        }
        this.target.add("org/apache/derby/impl/jdbc/EmbedPreparedStatement");
        this.target.add("org/apache/derby/client/am/PreparedStatement");
        this.target.add("net/sourceforge/jtds/jdbc/JtdsPreparedStatement");
        this.target.add("bmt/jdbc/FakePreparedStatement");
        this.target.add("jdbc/FakePreparedStatement");
        this.target.add("jdbc/FakePreparedStatement2");
        this.target.add("com/microsoft/sqlserver/jdbc/SQLServerPreparedStatement");
        this.target.add("org/hsqldb/jdbc/JDBCPreparedStatement");
        this.target.add("cubrid/jdbc/driver/CUBRIDPreparedStatement");
        this.target.add("org/postgresql/jdbc2/AbstractJdbc2Statement");
        this.target.add("org/postgresql/jdbc/PgPreparedStatement");
        this.target.add("com/edb/jdbc/PgPreparedStatement");
        this.target.add("com/edb/jdbc2/AbstractJdbc2Statement");
        this.target.add("Altibase5/jdbc/driver/ABPreparedStatement");
        this.target.add("Altibase/jdbc/driver/AltibasePreparedStatement");
        this.target.add("Altibase/jdbc/driver/ABPreparedStatement");
        this.target.add("com/ibm/as400/access/AS400JDBCPreparedStatement");
        this.target.add("com/informix/jdbc/IfxPreparedStatement");
        this.target.add("com/tmax/tibero/jdbc/TbPreparedStatement");
        this.target.add("com/tmax/tibero/jdbc/driver/TbPreparedStatementImpl");
        this.target.add("org/h2/jdbc/JdbcPreparedStatement");
        this.target.add("com/sybase/jdbc2/jdbc/SybPreparedStatement");
        this.target.add("com/sybase/jdbc4/jdbc/SybPreparedStatement");
        noField.add("jdbc/FakePreparedStatement2");
        noField.add("com/mysql/jdbc/ServerPreparedStatement");
        noField.add("com/mysql/cj/jdbc/ServerPreparedStatement");
        noField.add("org/mariadb/jdbc/MariaDbClientPreparedStatement");
        noField.add("org/mariadb/jdbc/MariaDbServerPreparedStatement");
        noField.add("org/mariadb/jdbc/MariaDbPreparedStatementClient");
        noField.add("org/mariadb/jdbc/MariaDbPreparedStatementServer");
        noField.add("org/mariadb/jdbc/ClientSidePreparedStatement");
        noField.add("org/mariadb/jdbc/ClientPreparedStatement");
        noField.add("org/mariadb/jdbc/ServerPreparedStatement");
        noField.add("software/aws/rds/jdbc/mysql/shading/com/mysql/cj/jdbc/ServerPreparedStatement");
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_dbsql_enabled) {
            return cv;
        }
        if (!this.target.contains(className)) {
            return cv;
        }
        Logger.println("BCI", "jdbc-pstmt " + className);
        return new PreparedStatementCV(cv, sqlParam.get(className), className);
    }

    static {
        sqlParam.put("com/ibm/as400/access/AS400JDBCPreparedStatement", "Lcom/ibm/as400/access/JDSQLStatement;");
        ignoreInit = new HashSet();
        ignoreInit.add(new Pair<String, String>("com/mysql/jdbc/PreparedStatement", "(Lcom/mysql/jdbc/MySQLConnection;Ljava/lang/String;)V"));
        ignoreInit.add(new Pair<String, String>("com/mysql/cj/jdbc/PreparedStatement", "(Lcom/mysql/cj/api/jdbc/JdbcConnection;Ljava/lang/String;)V"));
        ignoreInit.add(new Pair<String, String>("com/mysql/cj/jdbc/ClientPreparedStatement", "(Lcom/mysql/cj/jdbc/JdbcConnection;Ljava/lang/String;)V"));
        noField = new HashSet();
    }
}

