/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.ClassDesc;
import whatap.agent.asm.ReservedSet;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.util.SystemUtil;

public abstract class IASM {
    public static boolean isASM4 = "true".equalsIgnoreCase(System.getProperty("asm4"));
    public static String asmVer = System.getProperty("asm", "0");
    public static int API = IASM.getApi();

    private static int getApi() {
        try {
            int n = Integer.parseInt(asmVer);
            switch (n) {
                case 4: {
                    return 262144;
                }
                case 5: {
                    return 327680;
                }
                case 6: {
                    return 393216;
                }
                case 7: {
                    return 458752;
                }
                case 8: {
                    return 524288;
                }
                case 9: {
                    return 589824;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isASM4) {
            return 262144;
        }
        switch (SystemUtil.getMajorVersion()) {
            case 49: {
                return 262144;
            }
            case 50: 
            case 51: 
            case 52: {
                return 393216;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return 458752;
            }
            case 59: 
            case 60: {
                return 524288;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                return 589824;
            }
        }
        return 589824;
    }

    public abstract ClassVisitor transform(ClassVisitor var1, String var2, ClassDesc var3);

    public abstract void reserved(ReservedSet var1);

    public static String getAsm() {
        switch (API) {
            case 262144: {
                return "asm4";
            }
            case 327680: {
                return "asm5";
            }
            case 393216: {
                return "asm6";
            }
            case 458752: {
                return "asm7";
            }
            case 524288: {
                return "asm8";
            }
            case 589824: {
                return "asm9";
            }
        }
        return "asm0";
    }
}

