/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.asm.jdbc.JdbcAsm;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class DbcCloseMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_SQL = JdbcAsm.TRACE_SQL;
    private static final String START_METHOD = "dbcCloseStart";
    private static final String START_SIGNATURE = "(ILjava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;";
    private static final String END_METHOD = "dbcCloseEnd";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private int fullname_hash;
    private String fullname;
    private int statIdx;

    public DbcCloseMV(int access, String desc, MethodVisitor mv, int fullname_hash, String fullname) {
        super(IASM.API, access, desc, mv);
        this.fullname = fullname;
        this.fullname_hash = fullname_hash;
    }

    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.fullname_hash);
        AsmUtil.PUSH(this.mv, this.fullname);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitMethodInsn(184, TRACE_SQL, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(Object.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, this.statIdx);
            AsmUtil.PUSHNULL(this.mv);
            this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

