/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.app.vertx;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.lang.pack.TagCountPack;
import whatap.lang.value.ListValue;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.StringKeyLinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertxSendRequestStatCollector
extends Thread {
    private static VertxSendRequestStatCollector instance;
    private Object lock = new Object();
    long workTime;
    static Configure conf;
    StringKeyLinkedMap<VertxStat> vertxSendRequestTable = this.resetTable();
    long lastTime = DateUtil.nanoToMillis();

    public static synchronized VertxSendRequestStatCollector getInstance() {
        if (instance == null) {
            instance = new VertxSendRequestStatCollector();
            instance.setDaemon(true);
            instance.setName("VertxSendRequest");
            instance.start();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    Object object = this.lock;
                    synchronized (object) {
                        try {
                            this.lock.wait();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.process();
                }
            }
            catch (Throwable t) {
                Logger.println("VertxSendRequest", t.toString());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(long time) {
        this.workTime = time;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    protected void process() {
        long now = DateUtil.nanoToMillis();
        double interval = (double)(now - this.lastTime) / 1000.0;
        this.lastTime = now;
        if (interval <= 1.0) {
            return;
        }
        TagCountPack p = new TagCountPack();
        p.category = "vertx_send_request";
        p.tags.put("!rectype", 2);
        p.time = this.workTime;
        ListValue idLv = p.fields.newList("@id");
        ListValue addrLv = p.fields.newList("address");
        ListValue tpsLv = p.fields.newList("tps");
        ListValue cntLv = p.fields.newList("trace_count");
        ListValue errLv = p.fields.newList("trace_error");
        ListValue timeSumLv = p.fields.newList("elapsed_time_sum");
        ListValue timeMaxLv = p.fields.newList("elapsed_time_max");
        String[] keys = this.vertxSendRequestTable.keyArray();
        for (int i = 0; i < keys.length; ++i) {
            String name = keys[i];
            VertxStat vertxStat = this.vertxSendRequestTable.get(name);
            if (vertxStat == null) {
                vertxStat = new VertxStat();
            }
            idLv.add(HashUtil.hash(name));
            addrLv.add(name);
            tpsLv.add((float)((double)vertxStat.cnt / interval));
            cntLv.add(vertxStat.cnt);
            errLv.add(vertxStat.err);
            timeSumLv.add(vertxStat.elapsedTimeSum);
            timeMaxLv.add(vertxStat.elapsedTimeMax);
        }
        if (this.vertxSendRequestTable.size() > 0) {
            this.vertxSendRequestTable = this.resetTable();
        }
        if (VertxSendRequestStatCollector.conf.debug_vertx_context_enabled) {
            Logger.println("VertxSendRequest=" + p);
        }
        DataPackSender.send(p);
    }

    private StringKeyLinkedMap<VertxStat> resetTable() {
        return new StringKeyLinkedMap<VertxStat>(191, 1.0f){

            @Override
            protected VertxStat create(String key) {
                return new VertxStat();
            }
        };
    }

    public void endTrace(String contextName, int elapsed, Throwable failure) {
        if (contextName != null) {
            VertxStat p = this.vertxSendRequestTable.intern(contextName);
            this.processVertxStat(p, elapsed, failure);
        }
    }

    private void processVertxStat(VertxStat p, int elapsed, Throwable failure) {
        ++p.cnt;
        p.elapsedTimeSum += (long)elapsed;
        if (p.elapsedTimeMax < (long)elapsed) {
            p.elapsedTimeMax = elapsed;
        }
        if (failure != null) {
            ++p.err;
        }
    }

    public void startTrace(String contextName, long startTime) {
        this.vertxSendRequestTable.intern(contextName);
    }

    static {
        conf = Configure.getInstance();
    }

    static class VertxStat {
        int cnt;
        int err;
        long elapsedTimeSum;
        long elapsedTimeMax;

        VertxStat() {
        }
    }
}

