/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MessageStepX;
import whatap.lang.value.MapValue;
import whatap.util.HashUtil;

public class TxMessage {
    public static void trace(String name, String msg) {
        TxMessage.trace(TraceContextManager.getLocalContext(), name, msg);
    }

    public static void trace(String name, String msg, int value) {
        TxMessage.trace(TraceContextManager.getLocalContext(), name, msg, value);
    }

    public static void trace(TraceContext ctx, String name, String msg) {
        if (ctx != null) {
            MessageStep p = new MessageStep();
            p.start_time = ctx.getElapsedTime();
            p.hash = HashUtil.hash(name);
            DataTextAgent.MESSAGE.add(p.hash, name);
            p.desc = msg;
            ctx.profile.add(p);
        }
    }

    public static void trace(TraceContext ctx, String name, String msg, int value) {
        if (ctx != null) {
            MessageStep p = new MessageStep();
            p.start_time = ctx.getElapsedTime();
            p.hash = HashUtil.hash(name);
            DataTextAgent.MESSAGE.add(p.hash, name);
            p.desc = msg;
            p.value = value;
            ctx.profile.add(p);
        }
    }

    public static void traceX(TraceContext ctx, String title, String desc) {
        if (ctx != null) {
            MessageStepX p = new MessageStepX();
            p.start_time = ctx.getElapsedTime();
            p.title = title;
            int hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(hash, title);
            p.desc = desc;
            ctx.profile.add(p);
        }
    }

    public static void traceX(TraceContext ctx, String title, String desc, int ctr, MapValue attr) {
        if (ctx != null) {
            MessageStepX p = new MessageStepX();
            p.start_time = ctx.getElapsedTime();
            p.title = title;
            int hash = HashUtil.hash(title);
            DataTextAgent.MESSAGE.add(hash, title);
            p.desc = desc;
            p.ctr = ctr;
            p.attr = attr;
            ctx.profile.add(p);
        }
    }
}

