/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api;

import java.lang.ref.WeakReference;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;

public class WeakRepository {
    private static StringKeyLinkedMap<Bucket> entry = new StringKeyLinkedMap().setMax(1000);

    public static Object get(String key) {
        Bucket b = entry.get(key);
        return b == null ? null : b.data;
    }

    public Object get(String key, long time) {
        Bucket b = entry.get(key);
        if (b == null) {
            return null;
        }
        if (b.time + time >= System.currentTimeMillis()) {
            return b.data.get();
        }
        return null;
    }

    public static void put(String key, Object value) {
        entry.put(key, new Bucket(value));
    }

    public static void remove(String key) {
        entry.remove(key);
    }

    public static void expire(long time) {
        long now = System.currentTimeMillis();
        StringEnumer en = entry.keys();
        while (en.hasMoreElements()) {
            String key = en.nextString();
            Bucket b = entry.get(key);
            if (b.data.get() != null && b.time + time >= now) continue;
            entry.remove(key);
        }
    }

    private static class Bucket {
        long time = System.currentTimeMillis();
        WeakReference<Object> data;

        public Bucket(Object data) {
            this.data = new WeakReference<Object>(data);
        }
    }
}

