/*
 * Decompiled with CFR 0.152.
 */
package whatap;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import whatap.util.FileUtil;

public class Version {
    public static String getVersion() {
        Properties properties = Version.getProperties();
        if (properties != null) {
            return properties.get("VERSION").toString();
        }
        return "";
    }

    public static String getBuild() {
        Properties properties = Version.getProperties();
        if (properties != null) {
            return properties.get("BUILD").toString();
        }
        return "";
    }

    public static String getFullVersion() {
        return Version.getVersion() + " " + Version.getBuild();
    }

    public static void main(String[] args) {
        System.out.println("WhaTap Java v" + Version.getFullVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties() {
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = Version.class.getResourceAsStream("v.properties");
            properties.load(is);
        }
        catch (IOException e) {
            Properties properties2 = null;
            return properties2;
        }
        finally {
            FileUtil.close(is);
        }
        return properties;
    }

    public static Integer versionCompare(String str1, String str2) {
        int i;
        str1 = Version.numonly(str1);
        str2 = Version.numonly(str2);
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    private static String numonly(String t) {
        char[] c = t.toCharArray();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            switch (c[i]) {
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(c[i]);
                }
            }
        }
        return sb.toString();
    }
}

