#!/bin/sh


OS_TYPE=$(uname)
ACCESS_KEY=$1
SERVER_IP=$2
INSTALL_ROOT=${3:-/usr}
TYPE=${4:-swinstall}
ACTION=${5:-install}
CONF="$INSTALL_ROOT/whatap/infra/conf/whatap.conf"
SERVICE_SCRIPT="$INSTALL_ROOT/whatap/whatap-infra"
SERVICE_SCRIPT_TMP="$INSTALL_ROOT/whatap/whatap-infra.tmp"


# Function: convert version string X.Y.Z to integer XXXYYZZ for comparison
ver_to_int() {
    IFS='.' read major minor patch <<EOF
$1
EOF
    printf "%d%02d%02d" "$major" "$minor" "$patch"
}

# 운영체제에 따른 패키지 설치
if [ "$OS_TYPE" = "SunOS" ]; then
    echo "OS : SunOS"
    exit 1
elif [ "$OS_TYPE" = "HP-UX" ]; then
    echo "OS : HP-UX"
    echo "Install type: $TYPE"
    echo "Action: $ACTION"

    if [ "$ACTION" = "uninstall" ]; then
        echo "Uninstalling whatap-infra..."

        if [ "$TYPE" = "swinstall" ]; then
            echo "Using swremove for uninstall"
            swremove whatap-infra
        elif [ "$TYPE" = "cp" ]; then
            echo "Using manual removal for cp installation"

            # Remove service links
            rm -f /sbin/init.d/whatap-infra
            rm -f /sbin/rc3.d/S999whatap-infra

            # Stop service if running
            if [ -f "$SERVICE_SCRIPT" ]; then
                $SERVICE_SCRIPT stop 2>/dev/null || true
            fi

            # Remove whatap directory
            if [ -d "$INSTALL_ROOT/whatap" ]; then
                echo "Removing $INSTALL_ROOT/whatap directory..."
                rm -rf "$INSTALL_ROOT/whatap"
            fi

            echo "Manual removal completed"
        else
            echo "Error: Invalid installation type '$TYPE'. Use 'swinstall' or 'cp'"
            exit 1
        fi

        echo "Uninstall Complete."
        exit 0

    elif [ "$ACTION" = "install" ]; then
        echo "Installing whatap-infra..."

        if [ "$TYPE" = "swinstall" ]; then
        # swagentd 프로세스 확인
        PROCESS_COUNT=$(ps -ef | grep swagentd | grep -v grep | wc -l)

        # 프로세스 개수가 1 미만인지 확인
        if [ "$PROCESS_COUNT" -lt 1 ]; then
            echo "swagentd check fail"
            echo "please execute '/usr/sbin/swagentd -r'"
            exit 1
        else
            echo "swagentd check ok"

            DO_REMOVE=false
            INSTALLED_VER=$(swlist -l product whatap-infra 2>/dev/null | awk '/whatap-infra/ {print $2}')
            if [ -n "$INSTALLED_VER" ]; then
                echo "Detected installed version: $INSTALLED_VER"
                INST_INT=$(ver_to_int "$INSTALLED_VER")
                THRESHOLD=$(ver_to_int "1.4.4")
                if [ "$INST_INT" -le "$THRESHOLD" ]; then
                    echo "Version <= 1.4.4 detected; scheduling removal before install"
                    DO_REMOVE=true
                fi
            fi

            # Remove old package if needed
            if $DO_REMOVE; then
                echo "Removing existing whatap-infra..."
                swremove whatap-infra
            fi

            CURRENT_DIR=$(pwd)
            TARGET_DEPOT=$(find ./ -type d -name "whatap-infra*depot" | awk -F'-' '{print $NF, $0}' | sort -n -t. -k1,1 -k2,2 -k3,3 | awk '{$1=""; print substr($0,2)}' | tail -n 1)

            TARGET_PATH="$CURRENT_DIR/$TARGET_DEPOT"
            echo "$TARGET_PATH"

            swinstall -x mount_all_filesystems=false -s "$TARGET_PATH" whatap-infra:$INSTALL_ROOT
        fi

    elif [ "$TYPE" = "cp" ]; then
        echo "Using cp installation method"

        # Find the source directory containing whatap files
        CURRENT_DIR=$(pwd)
        SOURCE_DIR=$(find ./ -type d -name "whatap-infra*" | grep -v depot | head -1)

        if [ -z "$SOURCE_DIR" ]; then
            echo "Error: No whatap-infra source directory found"
            exit 1
        fi

        echo "Source directory: $SOURCE_DIR"

        # Create target directory
        mkdir -p "$INSTALL_ROOT/whatap"

        # Copy files
        echo "Copying files from $SOURCE_DIR to $INSTALL_ROOT/whatap/"
        cp -r "$SOURCE_DIR"/* "$INSTALL_ROOT/whatap/"

        if [ $? -ne 0 ]; then
            echo "Error: Failed to copy files"
            exit 1
        fi

        echo "Files copied successfully"

    else
        echo "Error: Invalid installation type '$TYPE'. Use 'swinstall' or 'cp'"
        exit 1
    fi

    # Common post-installation steps for both methods
    sed "s|/usr/whatap|$INSTALL_ROOT/whatap|g" $SERVICE_SCRIPT > $SERVICE_SCRIPT_TMP
    mv $SERVICE_SCRIPT_TMP $SERVICE_SCRIPT
    chmod 755 $SERVICE_SCRIPT
    ln -sf $SERVICE_SCRIPT /sbin/init.d/whatap-infra
    ln -sf /sbin/init.d/whatap-infra /sbin/rc3.d/S999whatap-infra

    PYTHON_FILE=$INSTALL_ROOT/whatap/infra/whatap_infrad
    PYTHON_FILE_TMP=$INSTALL_ROOT/whatap/infra/whatap_infrad.tmp
    if [ -f $PYTHON_FILE ]; then
        sed "s|/usr/whatap/infra|$INSTALL_ROOT/whatap/infra|g" $PYTHON_FILE > $PYTHON_FILE_TMP
        mv $PYTHON_FILE_TMP $PYTHON_FILE
        chmod 755 $PYTHON_FILE
    fi

    PYTHON_FILE2=$INSTALL_ROOT/whatap/infra/lib/lib/python2.7/site-packages/whatap/agent/conf/configure.py
    PYTHON_FILE2_TMP=$INSTALL_ROOT/whatap/infra/lib/lib/python2.7/site-packages/whatap/agent/conf/configure.py.tmp
    if [ -f $PYTHON_FILE2 ]; then
        sed "s|/usr/whatap/infra|$INSTALL_ROOT/whatap/infra|g" $PYTHON_FILE2 > $PYTHON_FILE2_TMP
        mv $PYTHON_FILE2_TMP $PYTHON_FILE2
    fi

    if [ -f "$CONF" ]; then
        echo "File $CONF exists."
        echo "Do you want to overwrite the file? (y/n):"
        read USER_INPUT

        if [ "$USER_INPUT" = "y" ] || [ "$USER_INPUT" = "Y" ]; then
            CREATED_TIME=`perl -e 'use Time::HiRes qw(gettimeofday); ($seconds, $microseconds) = gettimeofday; print ($seconds * 1000 + int($microseconds / 1000)), "\n";'`
            rm $CONF
            echo "license=$ACCESS_KEY" | tee $CONF
            echo "whatap.server.host=$SERVER_IP" | tee -a $CONF
            echo "createdtime=$CREATED_TIME" | tee -a $CONF
        else
            echo "File not deleted."
        fi
    else
        CREATED_TIME=`perl -e 'use Time::HiRes qw(gettimeofday); ($seconds, $microseconds) = gettimeofday; print ($seconds * 1000 + int($microseconds / 1000)), "\n";'`
        echo "license=$ACCESS_KEY" | tee $CONF
        echo "whatap.server.host=$SERVER_IP" | tee -a $CONF
        echo "createdtime=$CREATED_TIME" | tee -a $CONF
    fi

    echo "Install Complete."

    else
        echo "Error: Invalid action '$ACTION'. Use 'install' or 'uninstall'"
        exit 1
    fi
else
    echo "Unsupported OS: $OS_TYPE"
    exit 1
fi
