<?php
/**
 * 
 * @author Whatap
 *
 * @uses	
 * 			1. include this class
 * 			2. Start : Whatap::whatap_begin_step("Whatap_Tmp_Step",true);
 * 			3. End : Whatap::whatap_end_step();
 */
class Whatap {
	public function __construct() {
	}
	
	static function is_loaded() {
		return extension_loaded('whatap');
	}
	
	/**
	 * Begin
	 * @param String $step_name
	 * @param Boolean $stack_enabled
	 */
	static function whatap_begin_step($step_name, $stack_enabled) {
		if(Whatap::is_loaded()) {
			if (is_string($step_name) && is_bool($stack_enabled)) {
				whatap_begin_user_step($step_name, $stack_enabled);
			}
		}
	}
	
	/**
	 * End
	 */
	static function whatap_end_step() {
		if(Whatap::is_loaded()) {
			whatap_end_user_step();
		}
	}
	
	/**
	 * trace multi transaction
	 * add request header for Http connection ( eg: cURL) 
	 * @return array(key=>value) HTTP Header key => Value  
	 */ 
	static function whatap_get_mtrace() {
		if(Whatap::is_loaded()) {
			return whatap_mtrace_getopt();
		}
	}
	
	/**
	 * get trace multi transaction id 
	 * @return long
	 */
	static function whatap_mtid() {
	    if(Whatap::is_loaded()) {
	        return whatap_mtid();
	    }
	}
	

	/**
	 * Begin transaction in daemon
	 * @param String $service_name
	 */
	static function whatap_begin_tx($service_name) {
		if(Whatap::is_loaded()) {
			if (is_string($service_name) ) {
				whatap_begin_daemon_tx($service_name);
			}
		}
	}
	
	/**
	 * End transaction in daemon
	 */
	static function whatap_end_tx() {
		if(Whatap::is_loaded()) {
			whatap_end_daemon_tx();
		}
	}
	
}
?>